/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amp.model.LoggingDestination;
import software.amazon.awssdk.services.amp.model.LoggingDestinationsCopier;
import software.amazon.awssdk.services.amp.model.QueryLoggingConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryLoggingConfigurationMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryLoggingConfigurationMetadata> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(QueryLoggingConfigurationMetadata.getter(QueryLoggingConfigurationMetadata::createdAt)).setter(QueryLoggingConfigurationMetadata.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<List<LoggingDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(QueryLoggingConfigurationMetadata.getter(QueryLoggingConfigurationMetadata::destinations)).setter(QueryLoggingConfigurationMetadata.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoggingDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(QueryLoggingConfigurationMetadata.getter(QueryLoggingConfigurationMetadata::modifiedAt)).setter(QueryLoggingConfigurationMetadata.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<QueryLoggingConfigurationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(QueryLoggingConfigurationMetadata.getter(QueryLoggingConfigurationMetadata::status)).setter(QueryLoggingConfigurationMetadata.setter(Builder::status)).constructor(QueryLoggingConfigurationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKSPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspace").getter(QueryLoggingConfigurationMetadata.getter(QueryLoggingConfigurationMetadata::workspace)).setter(QueryLoggingConfigurationMetadata.setter(Builder::workspace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESTINATIONS_FIELD, MODIFIED_AT_FIELD, STATUS_FIELD, WORKSPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryLoggingConfigurationMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final List<LoggingDestination> destinations;
    private final Instant modifiedAt;
    private final QueryLoggingConfigurationStatus status;
    private final String workspace;

    private QueryLoggingConfigurationMetadata(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.destinations = builder.destinations;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.workspace = builder.workspace;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<LoggingDestination> destinations() {
        return this.destinations;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final QueryLoggingConfigurationStatus status() {
        return this.status;
    }

    public final String workspace() {
        return this.workspace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLoggingConfigurationMetadata)) {
            return false;
        }
        QueryLoggingConfigurationMetadata other = (QueryLoggingConfigurationMetadata)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.workspace(), other.workspace());
    }

    public final String toString() {
        return ToString.builder((String)"QueryLoggingConfigurationMetadata").add("CreatedAt", (Object)this.createdAt()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("ModifiedAt", (Object)this.modifiedAt()).add("Status", (Object)this.status()).add("Workspace", (Object)this.workspace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "workspace": {
                return Optional.ofNullable(clazz.cast(this.workspace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("workspace", WORKSPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryLoggingConfigurationMetadata, T> g) {
        return obj -> g.apply((QueryLoggingConfigurationMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private List<LoggingDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private Instant modifiedAt;
        private QueryLoggingConfigurationStatus status;
        private String workspace;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLoggingConfigurationMetadata model) {
            this.createdAt(model.createdAt);
            this.destinations(model.destinations);
            this.modifiedAt(model.modifiedAt);
            this.status(model.status);
            this.workspace(model.workspace);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<LoggingDestination.Builder> getDestinations() {
            List<LoggingDestination.Builder> result = LoggingDestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<LoggingDestination.BuilderImpl> destinations) {
            this.destinations = LoggingDestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<LoggingDestination> destinations) {
            this.destinations = LoggingDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(LoggingDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<LoggingDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (LoggingDestination)((LoggingDestination.Builder)LoggingDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final QueryLoggingConfigurationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(QueryLoggingConfigurationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(QueryLoggingConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public final String getWorkspace() {
            return this.workspace;
        }

        public final void setWorkspace(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public final Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public QueryLoggingConfigurationMetadata build() {
            return new QueryLoggingConfigurationMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryLoggingConfigurationMetadata> {
        public Builder createdAt(Instant var1);

        public Builder destinations(Collection<LoggingDestination> var1);

        public Builder destinations(LoggingDestination ... var1);

        public Builder destinations(Consumer<LoggingDestination.Builder> ... var1);

        public Builder modifiedAt(Instant var1);

        public Builder status(QueryLoggingConfigurationStatus var1);

        default public Builder status(Consumer<QueryLoggingConfigurationStatus.Builder> status) {
            return this.status((QueryLoggingConfigurationStatus)((QueryLoggingConfigurationStatus.Builder)QueryLoggingConfigurationStatus.builder().applyMutation(status)).build());
        }

        public Builder workspace(String var1);
    }
}

