/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<AmpConfiguration> AMP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ampConfiguration").getter(Destination.getter(Destination::ampConfiguration)).setter(Destination.setter(Builder::ampConfiguration)).constructor(AmpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ampConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMP_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AmpConfiguration ampConfiguration;
    private final Type type;

    private Destination(BuilderImpl builder) {
        this.ampConfiguration = builder.ampConfiguration;
        this.type = builder.type;
    }

    public final AmpConfiguration ampConfiguration() {
        return this.ampConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ampConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.ampConfiguration(), other.ampConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("AmpConfiguration", (Object)this.ampConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ampConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ampConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static Destination fromAmpConfiguration(AmpConfiguration ampConfiguration) {
        return (Destination)Destination.builder().ampConfiguration(ampConfiguration).build();
    }

    public static Destination fromAmpConfiguration(Consumer<AmpConfiguration.Builder> ampConfiguration) {
        AmpConfiguration.Builder builder = AmpConfiguration.builder();
        ampConfiguration.accept(builder);
        return Destination.fromAmpConfiguration((AmpConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<AmpConfiguration>> map = new HashMap<String, SdkField<AmpConfiguration>>();
        map.put("ampConfiguration", AMP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AMP_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AmpConfiguration ampConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.ampConfiguration(model.ampConfiguration);
        }

        public final AmpConfiguration.Builder getAmpConfiguration() {
            return this.ampConfiguration != null ? this.ampConfiguration.toBuilder() : null;
        }

        public final void setAmpConfiguration(AmpConfiguration.BuilderImpl ampConfiguration) {
            AmpConfiguration oldValue = this.ampConfiguration;
            this.ampConfiguration = ampConfiguration != null ? ampConfiguration.build() : null;
            this.handleUnionValueChange(Type.AMP_CONFIGURATION, oldValue, this.ampConfiguration);
        }

        @Override
        public final Builder ampConfiguration(AmpConfiguration ampConfiguration) {
            AmpConfiguration oldValue = this.ampConfiguration;
            this.ampConfiguration = ampConfiguration;
            this.handleUnionValueChange(Type.AMP_CONFIGURATION, oldValue, this.ampConfiguration);
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder ampConfiguration(AmpConfiguration var1);

        default public Builder ampConfiguration(Consumer<AmpConfiguration.Builder> ampConfiguration) {
            return this.ampConfiguration((AmpConfiguration)((AmpConfiguration.Builder)AmpConfiguration.builder().applyMutation(ampConfiguration)).build());
        }
    }
}

