/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkspaceAliasRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, UpdateWorkspaceAliasRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(UpdateWorkspaceAliasRequest.getter(UpdateWorkspaceAliasRequest::alias)).setter(UpdateWorkspaceAliasRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateWorkspaceAliasRequest.getter(UpdateWorkspaceAliasRequest::clientToken)).setter(UpdateWorkspaceAliasRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdateWorkspaceAliasRequest.getter(UpdateWorkspaceAliasRequest::workspaceId)).setter(UpdateWorkspaceAliasRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, CLIENT_TOKEN_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkspaceAliasRequest.memberNameToFieldInitializer();
    private final String alias;
    private final String clientToken;
    private final String workspaceId;

    private UpdateWorkspaceAliasRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.workspaceId = builder.workspaceId;
    }

    public final String alias() {
        return this.alias;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceAliasRequest)) {
            return false;
        }
        UpdateWorkspaceAliasRequest other = (UpdateWorkspaceAliasRequest)((Object)obj);
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkspaceAliasRequest").add("Alias", (Object)this.alias()).add("ClientToken", (Object)this.clientToken()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("alias", ALIAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceAliasRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String alias;
        private String clientToken;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceAliasRequest model) {
            super(model);
            this.alias(model.alias);
            this.clientToken(model.clientToken);
            this.workspaceId(model.workspaceId);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceAliasRequest build() {
            return new UpdateWorkspaceAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkspaceAliasRequest> {
        public Builder alias(String var1);

        public Builder clientToken(String var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

