/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleGroupsNamespaceRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, CreateRuleGroupsNamespaceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateRuleGroupsNamespaceRequest.getter(CreateRuleGroupsNamespaceRequest::clientToken)).setter(CreateRuleGroupsNamespaceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("data").getter(CreateRuleGroupsNamespaceRequest.getter(CreateRuleGroupsNamespaceRequest::data)).setter(CreateRuleGroupsNamespaceRequest.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRuleGroupsNamespaceRequest.getter(CreateRuleGroupsNamespaceRequest::name)).setter(CreateRuleGroupsNamespaceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRuleGroupsNamespaceRequest.getter(CreateRuleGroupsNamespaceRequest::tags)).setter(CreateRuleGroupsNamespaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateRuleGroupsNamespaceRequest.getter(CreateRuleGroupsNamespaceRequest::workspaceId)).setter(CreateRuleGroupsNamespaceRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_FIELD, NAME_FIELD, TAGS_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRuleGroupsNamespaceRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final SdkBytes data;
    private final String name;
    private final Map<String, String> tags;
    private final String workspaceId;

    private CreateRuleGroupsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.data = builder.data;
        this.name = builder.name;
        this.tags = builder.tags;
        this.workspaceId = builder.workspaceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupsNamespaceRequest)) {
            return false;
        }
        CreateRuleGroupsNamespaceRequest other = (CreateRuleGroupsNamespaceRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRuleGroupsNamespaceRequest").add("ClientToken", (Object)this.clientToken()).add("Data", (Object)this.data()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("data", DATA_FIELD);
        map.put("name", NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupsNamespaceRequest, T> g) {
        return obj -> g.apply((CreateRuleGroupsNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private SdkBytes data;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupsNamespaceRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.data(model.data);
            this.name(model.name);
            this.tags(model.tags);
            this.workspaceId(model.workspaceId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleGroupsNamespaceRequest build() {
            return new CreateRuleGroupsNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleGroupsNamespaceRequest> {
        public Builder clientToken(String var1);

        public Builder data(SdkBytes var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

