/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.EksConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<EksConfiguration> EKS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksConfiguration").getter(Source.getter(Source::eksConfiguration)).setter(Source.setter(Builder::eksConfiguration)).constructor(EksConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Source.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EksConfiguration eksConfiguration;
    private final Type type;

    private Source(BuilderImpl builder) {
        this.eksConfiguration = builder.eksConfiguration;
        this.type = builder.type;
    }

    public final EksConfiguration eksConfiguration() {
        return this.eksConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.eksConfiguration(), other.eksConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Source").add("EksConfiguration", (Object)this.eksConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksConfiguration": {
                return Optional.ofNullable(clazz.cast(this.eksConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static Source fromEksConfiguration(EksConfiguration eksConfiguration) {
        return (Source)Source.builder().eksConfiguration(eksConfiguration).build();
    }

    public static Source fromEksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
        EksConfiguration.Builder builder = EksConfiguration.builder();
        eksConfiguration.accept(builder);
        return Source.fromEksConfiguration((EksConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<EksConfiguration>> map = new HashMap<String, SdkField<EksConfiguration>>();
        map.put("eksConfiguration", EKS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EKS_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EksConfiguration eksConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.eksConfiguration(model.eksConfiguration);
        }

        public final EksConfiguration.Builder getEksConfiguration() {
            return this.eksConfiguration != null ? this.eksConfiguration.toBuilder() : null;
        }

        public final void setEksConfiguration(EksConfiguration.BuilderImpl eksConfiguration) {
            EksConfiguration oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration != null ? eksConfiguration.build() : null;
            this.handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
        }

        @Override
        public final Builder eksConfiguration(EksConfiguration eksConfiguration) {
            EksConfiguration oldValue = this.eksConfiguration;
            this.eksConfiguration = eksConfiguration;
            this.handleUnionValueChange(Type.EKS_CONFIGURATION, oldValue, this.eksConfiguration);
            return this;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder eksConfiguration(EksConfiguration var1);

        default public Builder eksConfiguration(Consumer<EksConfiguration.Builder> eksConfiguration) {
            return this.eksConfiguration((EksConfiguration)((EksConfiguration.Builder)EksConfiguration.builder().applyMutation(eksConfiguration)).build());
        }
    }
}

