/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amp.model.AmpRequest;
import software.amazon.awssdk.services.amp.model.Destination;
import software.amazon.awssdk.services.amp.model.RoleConfiguration;
import software.amazon.awssdk.services.amp.model.ScrapeConfiguration;
import software.amazon.awssdk.services.amp.model.Source;
import software.amazon.awssdk.services.amp.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScraperRequest
extends AmpRequest
implements ToCopyableBuilder<Builder, CreateScraperRequest> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(CreateScraperRequest.getter(CreateScraperRequest::alias)).setter(CreateScraperRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateScraperRequest.getter(CreateScraperRequest::clientToken)).setter(CreateScraperRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destination").getter(CreateScraperRequest.getter(CreateScraperRequest::destination)).setter(CreateScraperRequest.setter(Builder::destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<RoleConfiguration> ROLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("roleConfiguration").getter(CreateScraperRequest.getter(CreateScraperRequest::roleConfiguration)).setter(CreateScraperRequest.setter(Builder::roleConfiguration)).constructor(RoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleConfiguration").build()}).build();
    private static final SdkField<ScrapeConfiguration> SCRAPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scrapeConfiguration").getter(CreateScraperRequest.getter(CreateScraperRequest::scrapeConfiguration)).setter(CreateScraperRequest.setter(Builder::scrapeConfiguration)).constructor(ScrapeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scrapeConfiguration").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateScraperRequest.getter(CreateScraperRequest::source)).setter(CreateScraperRequest.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateScraperRequest.getter(CreateScraperRequest::tags)).setter(CreateScraperRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, CLIENT_TOKEN_FIELD, DESTINATION_FIELD, ROLE_CONFIGURATION_FIELD, SCRAPE_CONFIGURATION_FIELD, SOURCE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScraperRequest.memberNameToFieldInitializer();
    private final String alias;
    private final String clientToken;
    private final Destination destination;
    private final RoleConfiguration roleConfiguration;
    private final ScrapeConfiguration scrapeConfiguration;
    private final Source source;
    private final Map<String, String> tags;

    private CreateScraperRequest(BuilderImpl builder) {
        super(builder);
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.destination = builder.destination;
        this.roleConfiguration = builder.roleConfiguration;
        this.scrapeConfiguration = builder.scrapeConfiguration;
        this.source = builder.source;
        this.tags = builder.tags;
    }

    public final String alias() {
        return this.alias;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Destination destination() {
        return this.destination;
    }

    public final RoleConfiguration roleConfiguration() {
        return this.roleConfiguration;
    }

    public final ScrapeConfiguration scrapeConfiguration() {
        return this.scrapeConfiguration;
    }

    public final Source source() {
        return this.source;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scrapeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScraperRequest)) {
            return false;
        }
        CreateScraperRequest other = (CreateScraperRequest)((Object)obj);
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.roleConfiguration(), other.roleConfiguration()) && Objects.equals(this.scrapeConfiguration(), other.scrapeConfiguration()) && Objects.equals(this.source(), other.source()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScraperRequest").add("Alias", (Object)this.alias()).add("ClientToken", (Object)this.clientToken()).add("Destination", (Object)this.destination()).add("RoleConfiguration", (Object)this.roleConfiguration()).add("ScrapeConfiguration", (Object)this.scrapeConfiguration()).add("Source", (Object)this.source()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "roleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.roleConfiguration()));
            }
            case "scrapeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scrapeConfiguration()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alias", ALIAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("roleConfiguration", ROLE_CONFIGURATION_FIELD);
        map.put("scrapeConfiguration", SCRAPE_CONFIGURATION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScraperRequest, T> g) {
        return obj -> g.apply((CreateScraperRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmpRequest.BuilderImpl
    implements Builder {
        private String alias;
        private String clientToken;
        private Destination destination;
        private RoleConfiguration roleConfiguration;
        private ScrapeConfiguration scrapeConfiguration;
        private Source source;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScraperRequest model) {
            super(model);
            this.alias(model.alias);
            this.clientToken(model.clientToken);
            this.destination(model.destination);
            this.roleConfiguration(model.roleConfiguration);
            this.scrapeConfiguration(model.scrapeConfiguration);
            this.source(model.source);
            this.tags(model.tags);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final RoleConfiguration.Builder getRoleConfiguration() {
            return this.roleConfiguration != null ? this.roleConfiguration.toBuilder() : null;
        }

        public final void setRoleConfiguration(RoleConfiguration.BuilderImpl roleConfiguration) {
            this.roleConfiguration = roleConfiguration != null ? roleConfiguration.build() : null;
        }

        @Override
        public final Builder roleConfiguration(RoleConfiguration roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        public final ScrapeConfiguration.Builder getScrapeConfiguration() {
            return this.scrapeConfiguration != null ? this.scrapeConfiguration.toBuilder() : null;
        }

        public final void setScrapeConfiguration(ScrapeConfiguration.BuilderImpl scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration != null ? scrapeConfiguration.build() : null;
        }

        @Override
        public final Builder scrapeConfiguration(ScrapeConfiguration scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScraperRequest build() {
            return new CreateScraperRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmpRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScraperRequest> {
        public Builder alias(String var1);

        public Builder clientToken(String var1);

        public Builder destination(Destination var1);

        default public Builder destination(Consumer<Destination.Builder> destination) {
            return this.destination((Destination)((Destination.Builder)Destination.builder().applyMutation(destination)).build());
        }

        public Builder roleConfiguration(RoleConfiguration var1);

        default public Builder roleConfiguration(Consumer<RoleConfiguration.Builder> roleConfiguration) {
            return this.roleConfiguration((RoleConfiguration)((RoleConfiguration.Builder)RoleConfiguration.builder().applyMutation(roleConfiguration)).build());
        }

        public Builder scrapeConfiguration(ScrapeConfiguration var1);

        default public Builder scrapeConfiguration(Consumer<ScrapeConfiguration.Builder> scrapeConfiguration) {
            return this.scrapeConfiguration((ScrapeConfiguration)((ScrapeConfiguration.Builder)ScrapeConfiguration.builder().applyMutation(scrapeConfiguration)).build());
        }

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

