/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amp.model.WorkspaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceDescription> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(WorkspaceDescription.getter(WorkspaceDescription::alias)).setter(WorkspaceDescription.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(WorkspaceDescription.getter(WorkspaceDescription::arn)).setter(WorkspaceDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorkspaceDescription.getter(WorkspaceDescription::createdAt)).setter(WorkspaceDescription.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> PROMETHEUS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prometheusEndpoint").getter(WorkspaceDescription.getter(WorkspaceDescription::prometheusEndpoint)).setter(WorkspaceDescription.setter(Builder::prometheusEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheusEndpoint").build()}).build();
    private static final SdkField<WorkspaceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(WorkspaceDescription.getter(WorkspaceDescription::status)).setter(WorkspaceDescription.setter(Builder::status)).constructor(WorkspaceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(WorkspaceDescription.getter(WorkspaceDescription::workspaceId)).setter(WorkspaceDescription.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, ARN_FIELD, CREATED_AT_FIELD, PROMETHEUS_ENDPOINT_FIELD, STATUS_FIELD, WORKSPACE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final String arn;
    private final Instant createdAt;
    private final String prometheusEndpoint;
    private final WorkspaceStatus status;
    private final String workspaceId;

    private WorkspaceDescription(BuilderImpl builder) {
        this.alias = builder.alias;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.prometheusEndpoint = builder.prometheusEndpoint;
        this.status = builder.status;
        this.workspaceId = builder.workspaceId;
    }

    public String alias() {
        return this.alias;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String prometheusEndpoint() {
        return this.prometheusEndpoint;
    }

    public WorkspaceStatus status() {
        return this.status;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.prometheusEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDescription)) {
            return false;
        }
        WorkspaceDescription other = (WorkspaceDescription)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.prometheusEndpoint(), other.prometheusEndpoint()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public String toString() {
        return ToString.builder((String)"WorkspaceDescription").add("Alias", (Object)this.alias()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("PrometheusEndpoint", (Object)this.prometheusEndpoint()).add("Status", (Object)this.status()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "prometheusEndpoint": {
                return Optional.ofNullable(clazz.cast(this.prometheusEndpoint()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDescription, T> g) {
        return obj -> g.apply((WorkspaceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private String arn;
        private Instant createdAt;
        private String prometheusEndpoint;
        private WorkspaceStatus status;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDescription model) {
            this.alias(model.alias);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.prometheusEndpoint(model.prometheusEndpoint);
            this.status(model.status);
            this.workspaceId(model.workspaceId);
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getPrometheusEndpoint() {
            return this.prometheusEndpoint;
        }

        @Override
        public final Builder prometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
            return this;
        }

        public final void setPrometheusEndpoint(String prometheusEndpoint) {
            this.prometheusEndpoint = prometheusEndpoint;
        }

        public final WorkspaceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(WorkspaceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(WorkspaceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        public WorkspaceDescription build() {
            return new WorkspaceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceDescription> {
        public Builder alias(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder prometheusEndpoint(String var1);

        public Builder status(WorkspaceStatus var1);

        default public Builder status(Consumer<WorkspaceStatus.Builder> status) {
            return this.status((WorkspaceStatus)((WorkspaceStatus.Builder)WorkspaceStatus.builder().applyMutation(status)).build());
        }

        public Builder workspaceId(String var1);
    }
}

