/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionConfigurationType {
    AWS_OWNED_KEY("AWS_OWNED_KEY"),
    CUSTOMER_MANAGED_KMS_KEY("CUSTOMER_MANAGED_KMS_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionConfigurationType> VALUE_MAP;
    private final String value;

    private EncryptionConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionConfigurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionConfigurationType> knownValues() {
        EnumSet<EncryptionConfigurationType> knownValues = EnumSet.allOf(EncryptionConfigurationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionConfigurationType.class, EncryptionConfigurationType::toString);
    }
}

