/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.aiops.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about the cross-account configuration in the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossAccountConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossAccountConfiguration.Builder, CrossAccountConfiguration> {
    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRoleArn").getter(getter(CrossAccountConfiguration::sourceRoleArn))
            .setter(setter(Builder::sourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceRoleArn;

    private CrossAccountConfiguration(BuilderImpl builder) {
        this.sourceRoleArn = builder.sourceRoleArn;
    }

    /**
     * <p>
     * The ARN of an existing role which will be used to do investigations on your behalf.
     * </p>
     * 
     * @return The ARN of an existing role which will be used to do investigations on your behalf.
     */
    public final String sourceRoleArn() {
        return sourceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossAccountConfiguration)) {
            return false;
        }
        CrossAccountConfiguration other = (CrossAccountConfiguration) obj;
        return Objects.equals(sourceRoleArn(), other.sourceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossAccountConfiguration").add("SourceRoleArn", sourceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceRoleArn":
            return Optional.ofNullable(clazz.cast(sourceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceRoleArn", SOURCE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossAccountConfiguration, T> g) {
        return obj -> g.apply((CrossAccountConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossAccountConfiguration> {
        /**
         * <p>
         * The ARN of an existing role which will be used to do investigations on your behalf.
         * </p>
         * 
         * @param sourceRoleArn
         *        The ARN of an existing role which will be used to do investigations on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRoleArn(String sourceRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String sourceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossAccountConfiguration model) {
            sourceRoleArn(model.sourceRoleArn);
        }

        public final String getSourceRoleArn() {
            return sourceRoleArn;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        @Override
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        @Override
        public CrossAccountConfiguration build() {
            return new CrossAccountConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
