/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.aiops;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.aiops.model.CreateInvestigationGroupRequest;
import software.amazon.awssdk.services.aiops.model.CreateInvestigationGroupResponse;
import software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupPolicyRequest;
import software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupPolicyResponse;
import software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupRequest;
import software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupResponse;
import software.amazon.awssdk.services.aiops.model.GetInvestigationGroupPolicyRequest;
import software.amazon.awssdk.services.aiops.model.GetInvestigationGroupPolicyResponse;
import software.amazon.awssdk.services.aiops.model.GetInvestigationGroupRequest;
import software.amazon.awssdk.services.aiops.model.GetInvestigationGroupResponse;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest;
import software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse;
import software.amazon.awssdk.services.aiops.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.aiops.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.aiops.model.PutInvestigationGroupPolicyRequest;
import software.amazon.awssdk.services.aiops.model.PutInvestigationGroupPolicyResponse;
import software.amazon.awssdk.services.aiops.model.TagResourceRequest;
import software.amazon.awssdk.services.aiops.model.TagResourceResponse;
import software.amazon.awssdk.services.aiops.model.UntagResourceRequest;
import software.amazon.awssdk.services.aiops.model.UntagResourceResponse;
import software.amazon.awssdk.services.aiops.model.UpdateInvestigationGroupRequest;
import software.amazon.awssdk.services.aiops.model.UpdateInvestigationGroupResponse;
import software.amazon.awssdk.services.aiops.paginators.ListInvestigationGroupsPublisher;

/**
 * Service client for accessing AWS AI Ops asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * The CloudWatch investigations feature is a generative AI-powered assistant that can help you respond to incidents in
 * your system. It uses generative AI to scan your system's telemetry and quickly surface suggestions that might be
 * related to your issue. These suggestions include metrics, logs, deployment events, and root-cause hypotheses.
 * </p>
 * <p>
 * You can use API actions to create, manage, and delete investigation groups and investigation group policies. To start
 * and manage investigations, you must use the CloudWatch console.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AiOpsAsyncClient extends AwsClient {
    String SERVICE_NAME = "aiops";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "aiops";

    /**
     * <p>
     * Creates an <i>investigation group</i> in your account. Creating an investigation group is a one-time setup task
     * for each Region in your account. It is a necessary task to be able to perform investigations.
     * </p>
     * <p>
     * Settings in the investigation group help you centrally manage the common properties of your investigations, such
     * as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Who can access the investigations
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether investigation data is encrypted with a customer managed Key Management Service key.
     * </p>
     * </li>
     * <li>
     * <p>
     * How long investigations and their data are retained by default.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Currently, you can have one investigation group in each Region in your account. Each investigation in a Region is
     * a part of the investigation group in that Region
     * </p>
     * <p>
     * To create an investigation group and set up CloudWatch investigations, you must be signed in to an IAM principal
     * that has either the <code>AIOpsConsoleAdminPolicy</code> or the <code>AdministratorAccess</code> IAM policy
     * attached, or to an account that has similar permissions.
     * </p>
     * <important>
     * <p>
     * You can configure CloudWatch alarms to start investigations and add events to investigations. If you create your
     * investigation group with <code>CreateInvestigationGroup</code> and you want to enable alarms to do this, you must
     * use <code>PutInvestigationGroupPolicy</code> to create a resource policy that grants this permission to
     * CloudWatch alarms.
     * </p>
     * <p>
     * For more information about configuring CloudWatch alarms, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html">Using Amazon
     * CloudWatch alarms</a>
     * </p>
     * </important>
     *
     * @param createInvestigationGroupRequest
     * @return A Java Future containing the result of the CreateInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.CreateInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/CreateInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInvestigationGroupResponse> createInvestigationGroup(
            CreateInvestigationGroupRequest createInvestigationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>investigation group</i> in your account. Creating an investigation group is a one-time setup task
     * for each Region in your account. It is a necessary task to be able to perform investigations.
     * </p>
     * <p>
     * Settings in the investigation group help you centrally manage the common properties of your investigations, such
     * as the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Who can access the investigations
     * </p>
     * </li>
     * <li>
     * <p>
     * Whether investigation data is encrypted with a customer managed Key Management Service key.
     * </p>
     * </li>
     * <li>
     * <p>
     * How long investigations and their data are retained by default.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Currently, you can have one investigation group in each Region in your account. Each investigation in a Region is
     * a part of the investigation group in that Region
     * </p>
     * <p>
     * To create an investigation group and set up CloudWatch investigations, you must be signed in to an IAM principal
     * that has either the <code>AIOpsConsoleAdminPolicy</code> or the <code>AdministratorAccess</code> IAM policy
     * attached, or to an account that has similar permissions.
     * </p>
     * <important>
     * <p>
     * You can configure CloudWatch alarms to start investigations and add events to investigations. If you create your
     * investigation group with <code>CreateInvestigationGroup</code> and you want to enable alarms to do this, you must
     * use <code>PutInvestigationGroupPolicy</code> to create a resource policy that grants this permission to
     * CloudWatch alarms.
     * </p>
     * <p>
     * For more information about configuring CloudWatch alarms, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html">Using Amazon
     * CloudWatch alarms</a>
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvestigationGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInvestigationGroupRequest#builder()}
     * </p>
     *
     * @param createInvestigationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.CreateInvestigationGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ServiceQuotaExceededException This request exceeds a service quota.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.CreateInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/CreateInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInvestigationGroupResponse> createInvestigationGroup(
            Consumer<CreateInvestigationGroupRequest.Builder> createInvestigationGroupRequest) {
        return createInvestigationGroup(CreateInvestigationGroupRequest.builder().applyMutation(createInvestigationGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified investigation group from your account. You can currently have one investigation group per
     * Region in your account. After you delete an investigation group, you can later create a new investigation group
     * in the same Region.
     * </p>
     *
     * @param deleteInvestigationGroupRequest
     * @return A Java Future containing the result of the DeleteInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.DeleteInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/DeleteInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInvestigationGroupResponse> deleteInvestigationGroup(
            DeleteInvestigationGroupRequest deleteInvestigationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified investigation group from your account. You can currently have one investigation group per
     * Region in your account. After you delete an investigation group, you can later create a new investigation group
     * in the same Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvestigationGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInvestigationGroupRequest#builder()}
     * </p>
     *
     * @param deleteInvestigationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.DeleteInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/DeleteInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInvestigationGroupResponse> deleteInvestigationGroup(
            Consumer<DeleteInvestigationGroupRequest.Builder> deleteInvestigationGroupRequest) {
        return deleteInvestigationGroup(DeleteInvestigationGroupRequest.builder().applyMutation(deleteInvestigationGroupRequest)
                .build());
    }

    /**
     * <p>
     * Removes the IAM resource policy from being associated with the investigation group that you specify.
     * </p>
     *
     * @param deleteInvestigationGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteInvestigationGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.DeleteInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/DeleteInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInvestigationGroupPolicyResponse> deleteInvestigationGroupPolicy(
            DeleteInvestigationGroupPolicyRequest deleteInvestigationGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the IAM resource policy from being associated with the investigation group that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvestigationGroupPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteInvestigationGroupPolicyRequest#builder()}
     * </p>
     *
     * @param deleteInvestigationGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.DeleteInvestigationGroupPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInvestigationGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.DeleteInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/DeleteInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInvestigationGroupPolicyResponse> deleteInvestigationGroupPolicy(
            Consumer<DeleteInvestigationGroupPolicyRequest.Builder> deleteInvestigationGroupPolicyRequest) {
        return deleteInvestigationGroupPolicy(DeleteInvestigationGroupPolicyRequest.builder()
                .applyMutation(deleteInvestigationGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information for the specified investigation group.
     * </p>
     *
     * @param getInvestigationGroupRequest
     * @return A Java Future containing the result of the GetInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.GetInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/GetInvestigationGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvestigationGroupResponse> getInvestigationGroup(
            GetInvestigationGroupRequest getInvestigationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information for the specified investigation group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvestigationGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvestigationGroupRequest#builder()}
     * </p>
     *
     * @param getInvestigationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.GetInvestigationGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.GetInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/GetInvestigationGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvestigationGroupResponse> getInvestigationGroup(
            Consumer<GetInvestigationGroupRequest.Builder> getInvestigationGroupRequest) {
        return getInvestigationGroup(GetInvestigationGroupRequest.builder().applyMutation(getInvestigationGroupRequest).build());
    }

    /**
     * <p>
     * Returns the JSON of the IAM resource policy associated with the specified investigation group in a string. For
     * example,
     * <code>{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":\"aiops.alarms.cloudwatch.amazonaws.com\"},\"Action\":[\"aiops:CreateInvestigation\",\"aiops:CreateInvestigationEvent\"],\"Resource\":\"*\",\"Condition\":{\"StringEquals\":{\"aws:SourceAccount\":\"111122223333\"},\"ArnLike\":{\"aws:SourceArn\":\"arn:aws:cloudwatch:us-east-1:111122223333:alarm:*\"}}}]}</code>
     * .
     * </p>
     *
     * @param getInvestigationGroupPolicyRequest
     * @return A Java Future containing the result of the GetInvestigationGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.GetInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/GetInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvestigationGroupPolicyResponse> getInvestigationGroupPolicy(
            GetInvestigationGroupPolicyRequest getInvestigationGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the JSON of the IAM resource policy associated with the specified investigation group in a string. For
     * example,
     * <code>{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"Service\":\"aiops.alarms.cloudwatch.amazonaws.com\"},\"Action\":[\"aiops:CreateInvestigation\",\"aiops:CreateInvestigationEvent\"],\"Resource\":\"*\",\"Condition\":{\"StringEquals\":{\"aws:SourceAccount\":\"111122223333\"},\"ArnLike\":{\"aws:SourceArn\":\"arn:aws:cloudwatch:us-east-1:111122223333:alarm:*\"}}}]}</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvestigationGroupPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetInvestigationGroupPolicyRequest#builder()}
     * </p>
     *
     * @param getInvestigationGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.GetInvestigationGroupPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvestigationGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.GetInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/GetInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvestigationGroupPolicyResponse> getInvestigationGroupPolicy(
            Consumer<GetInvestigationGroupPolicyRequest.Builder> getInvestigationGroupPolicyRequest) {
        return getInvestigationGroupPolicy(GetInvestigationGroupPolicyRequest.builder()
                .applyMutation(getInvestigationGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the ARN and name of each investigation group in the account.
     * </p>
     *
     * @param listInvestigationGroupsRequest
     * @return A Java Future containing the result of the ListInvestigationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListInvestigationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListInvestigationGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvestigationGroupsResponse> listInvestigationGroups(
            ListInvestigationGroupsRequest listInvestigationGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the ARN and name of each investigation group in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInvestigationGroupsRequest#builder()}
     * </p>
     *
     * @param listInvestigationGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInvestigationGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListInvestigationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListInvestigationGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvestigationGroupsResponse> listInvestigationGroups(
            Consumer<ListInvestigationGroupsRequest.Builder> listInvestigationGroupsRequest) {
        return listInvestigationGroups(ListInvestigationGroupsRequest.builder().applyMutation(listInvestigationGroupsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigationGroups(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.aiops.paginators.ListInvestigationGroupsPublisher publisher = client.listInvestigationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.aiops.paginators.ListInvestigationGroupsPublisher publisher = client.listInvestigationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigationGroups(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvestigationGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListInvestigationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListInvestigationGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvestigationGroupsPublisher listInvestigationGroupsPaginator(
            ListInvestigationGroupsRequest listInvestigationGroupsRequest) {
        return new ListInvestigationGroupsPublisher(this, listInvestigationGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvestigationGroups(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.aiops.paginators.ListInvestigationGroupsPublisher publisher = client.listInvestigationGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.aiops.paginators.ListInvestigationGroupsPublisher publisher = client.listInvestigationGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvestigationGroups(software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvestigationGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInvestigationGroupsRequest#builder()}
     * </p>
     *
     * @param listInvestigationGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.ListInvestigationGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListInvestigationGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListInvestigationGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvestigationGroupsPublisher listInvestigationGroupsPaginator(
            Consumer<ListInvestigationGroupsRequest.Builder> listInvestigationGroupsRequest) {
        return listInvestigationGroupsPaginator(ListInvestigationGroupsRequest.builder()
                .applyMutation(listInvestigationGroupsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch investigations resource. Currently, investigation groups support
     * tagging.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch investigations resource. Currently, investigation groups support
     * tagging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates an IAM resource policy and assigns it to the specified investigation group.
     * </p>
     * <p>
     * If you create your investigation group with <code>CreateInvestigationGroup</code> and you want to enable
     * CloudWatch alarms to create investigations and add events to investigations, you must use this operation to
     * create a policy similar to this example.
     * </p>
     * <p>
     * <code> { "Version": "2008-10-17", "Statement": [ { "Effect": "Allow", "Principal": { "Service": "aiops.alarms.cloudwatch.amazonaws.com" }, "Action": [ "aiops:CreateInvestigation", "aiops:CreateInvestigationEvent" ], "Resource": "*", "Condition": { "StringEquals": { "aws:SourceAccount": "account-id" }, "ArnLike": { "aws:SourceArn": "arn:aws:cloudwatch:region:account-id:alarm:*" } } } ] } </code>
     * </p>
     *
     * @param putInvestigationGroupPolicyRequest
     * @return A Java Future containing the result of the PutInvestigationGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.PutInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/PutInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvestigationGroupPolicyResponse> putInvestigationGroupPolicy(
            PutInvestigationGroupPolicyRequest putInvestigationGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IAM resource policy and assigns it to the specified investigation group.
     * </p>
     * <p>
     * If you create your investigation group with <code>CreateInvestigationGroup</code> and you want to enable
     * CloudWatch alarms to create investigations and add events to investigations, you must use this operation to
     * create a policy similar to this example.
     * </p>
     * <p>
     * <code> { "Version": "2008-10-17", "Statement": [ { "Effect": "Allow", "Principal": { "Service": "aiops.alarms.cloudwatch.amazonaws.com" }, "Action": [ "aiops:CreateInvestigation", "aiops:CreateInvestigationEvent" ], "Resource": "*", "Condition": { "StringEquals": { "aws:SourceAccount": "account-id" }, "ArnLike": { "aws:SourceArn": "arn:aws:cloudwatch:region:account-id:alarm:*" } } } ] } </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInvestigationGroupPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link PutInvestigationGroupPolicyRequest#builder()}
     * </p>
     *
     * @param putInvestigationGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.PutInvestigationGroupPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInvestigationGroupPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.PutInvestigationGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/PutInvestigationGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvestigationGroupPolicyResponse> putInvestigationGroupPolicy(
            Consumer<PutInvestigationGroupPolicyRequest.Builder> putInvestigationGroupPolicyRequest) {
        return putInvestigationGroupPolicy(PutInvestigationGroupPolicyRequest.builder()
                .applyMutation(putInvestigationGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the specified investigation group.
     * </p>
     *
     * @param updateInvestigationGroupRequest
     * @return A Java Future containing the result of the UpdateInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.UpdateInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/UpdateInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInvestigationGroupResponse> updateInvestigationGroup(
            UpdateInvestigationGroupRequest updateInvestigationGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the specified investigation group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInvestigationGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInvestigationGroupRequest#builder()}
     * </p>
     *
     * @param updateInvestigationGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.aiops.model.UpdateInvestigationGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateInvestigationGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You don't have sufficient permissions to perform this action.</li>
     *         <li>ForbiddenException Access id denied for this operation, or this operation is not valid for the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The specified resource doesn't exist.</li>
     *         <li>ThrottlingException The request was throttled because of quota limits. You can try again later.</li>
     *         <li>ValidationException This operation or its parameters aren't formatted correctly.</li>
     *         <li>InternalServerException An internal server error occurred. You can try again later.</li>
     *         <li>ConflictException This operation couldn't be completed because of a conflict in resource states.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AiOpsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AiOpsAsyncClient.UpdateInvestigationGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/aiops-2018-05-10/UpdateInvestigationGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInvestigationGroupResponse> updateInvestigationGroup(
            Consumer<UpdateInvestigationGroupRequest.Builder> updateInvestigationGroupRequest) {
        return updateInvestigationGroup(UpdateInvestigationGroupRequest.builder().applyMutation(updateInvestigationGroupRequest)
                .build());
    }

    @Override
    default AiOpsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AiOpsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AiOpsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AiOpsAsyncClient}.
     */
    static AiOpsAsyncClientBuilder builder() {
        return new DefaultAiOpsAsyncClientBuilder();
    }
}
