/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.aiops.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.aiops.model.AiOpsResponse;
import software.amazon.awssdk.services.aiops.model.ChatbotNotificationChannelCopier;
import software.amazon.awssdk.services.aiops.model.EncryptionConfiguration;
import software.amazon.awssdk.services.aiops.model.TagKeyBoundariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInvestigationGroupResponse
extends AiOpsResponse
implements ToCopyableBuilder<Builder, GetInvestigationGroupResponse> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::createdBy)).setter(GetInvestigationGroupResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::createdAt)).setter(GetInvestigationGroupResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastModifiedBy").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::lastModifiedBy)).setter(GetInvestigationGroupResponse.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedAt").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::lastModifiedAt)).setter(GetInvestigationGroupResponse.setter(Builder::lastModifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::name)).setter(GetInvestigationGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::arn)).setter(GetInvestigationGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::roleArn)).setter(GetInvestigationGroupResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::encryptionConfiguration)).setter(GetInvestigationGroupResponse.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<Long> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("retentionInDays").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::retentionInDays)).setter(GetInvestigationGroupResponse.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<Map<String, List<String>>> CHATBOT_NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("chatbotNotificationChannel").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::chatbotNotificationChannel)).setter(GetInvestigationGroupResponse.setter(Builder::chatbotNotificationChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotNotificationChannel").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_KEY_BOUNDARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tagKeyBoundaries").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::tagKeyBoundaries)).setter(GetInvestigationGroupResponse.setter(Builder::tagKeyBoundaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyBoundaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isCloudTrailEventHistoryEnabled").getter(GetInvestigationGroupResponse.getter(GetInvestigationGroupResponse::isCloudTrailEventHistoryEnabled)).setter(GetInvestigationGroupResponse.setter(Builder::isCloudTrailEventHistoryEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCloudTrailEventHistoryEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD, CREATED_AT_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, ARN_FIELD, ROLE_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD, RETENTION_IN_DAYS_FIELD, CHATBOT_NOTIFICATION_CHANNEL_FIELD, TAG_KEY_BOUNDARIES_FIELD, IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInvestigationGroupResponse.memberNameToFieldInitializer();
    private final String createdBy;
    private final Instant createdAt;
    private final String lastModifiedBy;
    private final Instant lastModifiedAt;
    private final String name;
    private final String arn;
    private final String roleArn;
    private final EncryptionConfiguration encryptionConfiguration;
    private final Long retentionInDays;
    private final Map<String, List<String>> chatbotNotificationChannel;
    private final List<String> tagKeyBoundaries;
    private final Boolean isCloudTrailEventHistoryEnabled;

    private GetInvestigationGroupResponse(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.retentionInDays = builder.retentionInDays;
        this.chatbotNotificationChannel = builder.chatbotNotificationChannel;
        this.tagKeyBoundaries = builder.tagKeyBoundaries;
        this.isCloudTrailEventHistoryEnabled = builder.isCloudTrailEventHistoryEnabled;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final Instant lastModifiedAt() {
        return this.lastModifiedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final Long retentionInDays() {
        return this.retentionInDays;
    }

    public final boolean hasChatbotNotificationChannel() {
        return this.chatbotNotificationChannel != null && !(this.chatbotNotificationChannel instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> chatbotNotificationChannel() {
        return this.chatbotNotificationChannel;
    }

    public final boolean hasTagKeyBoundaries() {
        return this.tagKeyBoundaries != null && !(this.tagKeyBoundaries instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeyBoundaries() {
        return this.tagKeyBoundaries;
    }

    public final Boolean isCloudTrailEventHistoryEnabled() {
        return this.isCloudTrailEventHistoryEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChatbotNotificationChannel() ? this.chatbotNotificationChannel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeyBoundaries() ? this.tagKeyBoundaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isCloudTrailEventHistoryEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvestigationGroupResponse)) {
            return false;
        }
        GetInvestigationGroupResponse other = (GetInvestigationGroupResponse)((Object)obj);
        return Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && this.hasChatbotNotificationChannel() == other.hasChatbotNotificationChannel() && Objects.equals(this.chatbotNotificationChannel(), other.chatbotNotificationChannel()) && this.hasTagKeyBoundaries() == other.hasTagKeyBoundaries() && Objects.equals(this.tagKeyBoundaries(), other.tagKeyBoundaries()) && Objects.equals(this.isCloudTrailEventHistoryEnabled(), other.isCloudTrailEventHistoryEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GetInvestigationGroupResponse").add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("LastModifiedAt", (Object)this.lastModifiedAt()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("RoleArn", (Object)this.roleArn()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("RetentionInDays", (Object)this.retentionInDays()).add("ChatbotNotificationChannel", this.hasChatbotNotificationChannel() ? this.chatbotNotificationChannel() : null).add("TagKeyBoundaries", this.hasTagKeyBoundaries() ? this.tagKeyBoundaries() : null).add("IsCloudTrailEventHistoryEnabled", (Object)this.isCloudTrailEventHistoryEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "lastModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "chatbotNotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.chatbotNotificationChannel()));
            }
            case "tagKeyBoundaries": {
                return Optional.ofNullable(clazz.cast(this.tagKeyBoundaries()));
            }
            case "isCloudTrailEventHistoryEnabled": {
                return Optional.ofNullable(clazz.cast(this.isCloudTrailEventHistoryEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("chatbotNotificationChannel", CHATBOT_NOTIFICATION_CHANNEL_FIELD);
        map.put("tagKeyBoundaries", TAG_KEY_BOUNDARIES_FIELD);
        map.put("isCloudTrailEventHistoryEnabled", IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvestigationGroupResponse, T> g) {
        return obj -> g.apply((GetInvestigationGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AiOpsResponse.BuilderImpl
    implements Builder {
        private String createdBy;
        private Instant createdAt;
        private String lastModifiedBy;
        private Instant lastModifiedAt;
        private String name;
        private String arn;
        private String roleArn;
        private EncryptionConfiguration encryptionConfiguration;
        private Long retentionInDays;
        private Map<String, List<String>> chatbotNotificationChannel = DefaultSdkAutoConstructMap.getInstance();
        private List<String> tagKeyBoundaries = DefaultSdkAutoConstructList.getInstance();
        private Boolean isCloudTrailEventHistoryEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvestigationGroupResponse model) {
            super(model);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedAt(model.lastModifiedAt);
            this.name(model.name);
            this.arn(model.arn);
            this.roleArn(model.roleArn);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.retentionInDays(model.retentionInDays);
            this.chatbotNotificationChannel(model.chatbotNotificationChannel);
            this.tagKeyBoundaries(model.tagKeyBoundaries);
            this.isCloudTrailEventHistoryEnabled(model.isCloudTrailEventHistoryEnabled);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return this.lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Long getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChatbotNotificationChannel() {
            if (this.chatbotNotificationChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.chatbotNotificationChannel;
        }

        public final void setChatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
        }

        @Override
        public final Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
            return this;
        }

        public final Collection<String> getTagKeyBoundaries() {
            if (this.tagKeyBoundaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeyBoundaries;
        }

        public final void setTagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
        }

        @Override
        public final Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyBoundaries(String ... tagKeyBoundaries) {
            this.tagKeyBoundaries(Arrays.asList(tagKeyBoundaries));
            return this;
        }

        public final Boolean getIsCloudTrailEventHistoryEnabled() {
            return this.isCloudTrailEventHistoryEnabled;
        }

        public final void setIsCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
        }

        @Override
        public final Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        @Override
        public GetInvestigationGroupResponse build() {
            return new GetInvestigationGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AiOpsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInvestigationGroupResponse> {
        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedAt(Instant var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder roleArn(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder retentionInDays(Long var1);

        public Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> var1);

        public Builder tagKeyBoundaries(Collection<String> var1);

        public Builder tagKeyBoundaries(String ... var1);

        public Builder isCloudTrailEventHistoryEnabled(Boolean var1);
    }
}

