/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCertificateAuthorityRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, DeleteCertificateAuthorityRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteCertificateAuthorityRequest.getter(DeleteCertificateAuthorityRequest::certificateAuthorityArn)).setter(DeleteCertificateAuthorityRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<Integer> PERMANENT_DELETION_TIME_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeleteCertificateAuthorityRequest.getter(DeleteCertificateAuthorityRequest::permanentDeletionTimeInDays)).setter(DeleteCertificateAuthorityRequest.setter(Builder::permanentDeletionTimeInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermanentDeletionTimeInDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, PERMANENT_DELETION_TIME_IN_DAYS_FIELD));
    private final String certificateAuthorityArn;
    private final Integer permanentDeletionTimeInDays;

    private DeleteCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.permanentDeletionTimeInDays = builder.permanentDeletionTimeInDays;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public Integer permanentDeletionTimeInDays() {
        return this.permanentDeletionTimeInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permanentDeletionTimeInDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCertificateAuthorityRequest)) {
            return false;
        }
        DeleteCertificateAuthorityRequest other = (DeleteCertificateAuthorityRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.permanentDeletionTimeInDays(), other.permanentDeletionTimeInDays());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCertificateAuthorityRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("PermanentDeletionTimeInDays", (Object)this.permanentDeletionTimeInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "PermanentDeletionTimeInDays": {
                return Optional.ofNullable(clazz.cast(this.permanentDeletionTimeInDays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((DeleteCertificateAuthorityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private Integer permanentDeletionTimeInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCertificateAuthorityRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.permanentDeletionTimeInDays(model.permanentDeletionTimeInDays);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final Integer getPermanentDeletionTimeInDays() {
            return this.permanentDeletionTimeInDays;
        }

        @Override
        public final Builder permanentDeletionTimeInDays(Integer permanentDeletionTimeInDays) {
            this.permanentDeletionTimeInDays = permanentDeletionTimeInDays;
            return this;
        }

        public final void setPermanentDeletionTimeInDays(Integer permanentDeletionTimeInDays) {
            this.permanentDeletionTimeInDays = permanentDeletionTimeInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteCertificateAuthorityRequest build() {
            return new DeleteCertificateAuthorityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteCertificateAuthorityRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder permanentDeletionTimeInDays(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

