/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CrlType {
    COMPLETE("COMPLETE"),
    PARTITIONED("PARTITIONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CrlType> VALUE_MAP;
    private final String value;

    private CrlType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CrlType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CrlType> knownValues() {
        EnumSet<CrlType> knownValues = EnumSet.allOf(CrlType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CrlType.class, CrlType::toString);
    }
}

