/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.RevocationReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokeCertificateRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, RevokeCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(RevokeCertificateRequest.getter(RevokeCertificateRequest::certificateAuthorityArn)).setter(RevokeCertificateRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateSerial").getter(RevokeCertificateRequest.getter(RevokeCertificateRequest::certificateSerial)).setter(RevokeCertificateRequest.setter(Builder::certificateSerial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSerial").build()}).build();
    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevocationReason").getter(RevokeCertificateRequest.getter(RevokeCertificateRequest::revocationReasonAsString)).setter(RevokeCertificateRequest.setter(Builder::revocationReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_SERIAL_FIELD, REVOCATION_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokeCertificateRequest.memberNameToFieldInitializer();
    private final String certificateAuthorityArn;
    private final String certificateSerial;
    private final String revocationReason;

    private RevokeCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificateSerial = builder.certificateSerial;
        this.revocationReason = builder.revocationReason;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final String certificateSerial() {
        return this.certificateSerial;
    }

    public final RevocationReason revocationReason() {
        return RevocationReason.fromValue(this.revocationReason);
    }

    public final String revocationReasonAsString() {
        return this.revocationReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSerial());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeCertificateRequest)) {
            return false;
        }
        RevokeCertificateRequest other = (RevokeCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.certificateSerial(), other.certificateSerial()) && Objects.equals(this.revocationReasonAsString(), other.revocationReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RevokeCertificateRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("CertificateSerial", (Object)this.certificateSerial()).add("RevocationReason", (Object)this.revocationReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "CertificateSerial": {
                return Optional.ofNullable(clazz.cast(this.certificateSerial()));
            }
            case "RevocationReason": {
                return Optional.ofNullable(clazz.cast(this.revocationReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CertificateAuthorityArn", CERTIFICATE_AUTHORITY_ARN_FIELD);
        map.put("CertificateSerial", CERTIFICATE_SERIAL_FIELD);
        map.put("RevocationReason", REVOCATION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeCertificateRequest, T> g) {
        return obj -> g.apply((RevokeCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private String certificateSerial;
        private String revocationReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeCertificateRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.certificateSerial(model.certificateSerial);
            this.revocationReason(model.revocationReason);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final String getCertificateSerial() {
            return this.certificateSerial;
        }

        public final void setCertificateSerial(String certificateSerial) {
            this.certificateSerial = certificateSerial;
        }

        @Override
        public final Builder certificateSerial(String certificateSerial) {
            this.certificateSerial = certificateSerial;
            return this;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason == null ? null : revocationReason.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeCertificateRequest build() {
            return new RevokeCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokeCertificateRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder certificateSerial(String var1);

        public Builder revocationReason(String var1);

        public Builder revocationReason(RevocationReason var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

