/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acmpca.model.CertificatePolicyListCopier;
import software.amazon.awssdk.services.acmpca.model.CustomExtension;
import software.amazon.awssdk.services.acmpca.model.CustomExtensionListCopier;
import software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsage;
import software.amazon.awssdk.services.acmpca.model.ExtendedKeyUsageListCopier;
import software.amazon.awssdk.services.acmpca.model.GeneralName;
import software.amazon.awssdk.services.acmpca.model.GeneralNameListCopier;
import software.amazon.awssdk.services.acmpca.model.KeyUsage;
import software.amazon.awssdk.services.acmpca.model.PolicyInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Extensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Extensions> {
    private static final SdkField<List<PolicyInformation>> CERTIFICATE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificatePolicies").getter(Extensions.getter(Extensions::certificatePolicies)).setter(Extensions.setter(Builder::certificatePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExtendedKeyUsage>> EXTENDED_KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtendedKeyUsage").getter(Extensions.getter(Extensions::extendedKeyUsage)).setter(Extensions.setter(Builder::extendedKeyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtendedKeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KeyUsage> KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyUsage").getter(Extensions.getter(Extensions::keyUsage)).setter(Extensions.setter(Builder::keyUsage)).constructor(KeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsage").build()}).build();
    private static final SdkField<List<GeneralName>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubjectAlternativeNames").getter(Extensions.getter(Extensions::subjectAlternativeNames)).setter(Extensions.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GeneralName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomExtension>> CUSTOM_EXTENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomExtensions").getter(Extensions.getter(Extensions::customExtensions)).setter(Extensions.setter(Builder::customExtensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomExtensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomExtension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_POLICIES_FIELD, EXTENDED_KEY_USAGE_FIELD, KEY_USAGE_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD, CUSTOM_EXTENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CertificatePolicies", CERTIFICATE_POLICIES_FIELD);
            this.put("ExtendedKeyUsage", EXTENDED_KEY_USAGE_FIELD);
            this.put("KeyUsage", KEY_USAGE_FIELD);
            this.put("SubjectAlternativeNames", SUBJECT_ALTERNATIVE_NAMES_FIELD);
            this.put("CustomExtensions", CUSTOM_EXTENSIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<PolicyInformation> certificatePolicies;
    private final List<ExtendedKeyUsage> extendedKeyUsage;
    private final KeyUsage keyUsage;
    private final List<GeneralName> subjectAlternativeNames;
    private final List<CustomExtension> customExtensions;

    private Extensions(BuilderImpl builder) {
        this.certificatePolicies = builder.certificatePolicies;
        this.extendedKeyUsage = builder.extendedKeyUsage;
        this.keyUsage = builder.keyUsage;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.customExtensions = builder.customExtensions;
    }

    public final boolean hasCertificatePolicies() {
        return this.certificatePolicies != null && !(this.certificatePolicies instanceof SdkAutoConstructList);
    }

    public final List<PolicyInformation> certificatePolicies() {
        return this.certificatePolicies;
    }

    public final boolean hasExtendedKeyUsage() {
        return this.extendedKeyUsage != null && !(this.extendedKeyUsage instanceof SdkAutoConstructList);
    }

    public final List<ExtendedKeyUsage> extendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public final KeyUsage keyUsage() {
        return this.keyUsage;
    }

    public final boolean hasSubjectAlternativeNames() {
        return this.subjectAlternativeNames != null && !(this.subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    public final List<GeneralName> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public final boolean hasCustomExtensions() {
        return this.customExtensions != null && !(this.customExtensions instanceof SdkAutoConstructList);
    }

    public final List<CustomExtension> customExtensions() {
        return this.customExtensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificatePolicies() ? this.certificatePolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedKeyUsage() ? this.extendedKeyUsage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomExtensions() ? this.customExtensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extensions)) {
            return false;
        }
        Extensions other = (Extensions)obj;
        return this.hasCertificatePolicies() == other.hasCertificatePolicies() && Objects.equals(this.certificatePolicies(), other.certificatePolicies()) && this.hasExtendedKeyUsage() == other.hasExtendedKeyUsage() && Objects.equals(this.extendedKeyUsage(), other.extendedKeyUsage()) && Objects.equals(this.keyUsage(), other.keyUsage()) && this.hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames() && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && this.hasCustomExtensions() == other.hasCustomExtensions() && Objects.equals(this.customExtensions(), other.customExtensions());
    }

    public final String toString() {
        return ToString.builder((String)"Extensions").add("CertificatePolicies", this.hasCertificatePolicies() ? this.certificatePolicies() : null).add("ExtendedKeyUsage", this.hasExtendedKeyUsage() ? this.extendedKeyUsage() : null).add("KeyUsage", (Object)this.keyUsage()).add("SubjectAlternativeNames", this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null).add("CustomExtensions", this.hasCustomExtensions() ? this.customExtensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificatePolicies": {
                return Optional.ofNullable(clazz.cast(this.certificatePolicies()));
            }
            case "ExtendedKeyUsage": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsage()));
            }
            case "KeyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsage()));
            }
            case "SubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "CustomExtensions": {
                return Optional.ofNullable(clazz.cast(this.customExtensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Extensions, T> g) {
        return obj -> g.apply((Extensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PolicyInformation> certificatePolicies = DefaultSdkAutoConstructList.getInstance();
        private List<ExtendedKeyUsage> extendedKeyUsage = DefaultSdkAutoConstructList.getInstance();
        private KeyUsage keyUsage;
        private List<GeneralName> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private List<CustomExtension> customExtensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Extensions model) {
            this.certificatePolicies(model.certificatePolicies);
            this.extendedKeyUsage(model.extendedKeyUsage);
            this.keyUsage(model.keyUsage);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.customExtensions(model.customExtensions);
        }

        public final List<PolicyInformation.Builder> getCertificatePolicies() {
            List<PolicyInformation.Builder> result = CertificatePolicyListCopier.copyToBuilder(this.certificatePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificatePolicies(Collection<PolicyInformation.BuilderImpl> certificatePolicies) {
            this.certificatePolicies = CertificatePolicyListCopier.copyFromBuilder(certificatePolicies);
        }

        @Override
        public final Builder certificatePolicies(Collection<PolicyInformation> certificatePolicies) {
            this.certificatePolicies = CertificatePolicyListCopier.copy(certificatePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatePolicies(PolicyInformation ... certificatePolicies) {
            this.certificatePolicies(Arrays.asList(certificatePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificatePolicies(Consumer<PolicyInformation.Builder> ... certificatePolicies) {
            this.certificatePolicies(Stream.of(certificatePolicies).map(c -> (PolicyInformation)((PolicyInformation.Builder)PolicyInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExtendedKeyUsage.Builder> getExtendedKeyUsage() {
            List<ExtendedKeyUsage.Builder> result = ExtendedKeyUsageListCopier.copyToBuilder(this.extendedKeyUsage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtendedKeyUsage(Collection<ExtendedKeyUsage.BuilderImpl> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageListCopier.copyFromBuilder(extendedKeyUsage);
        }

        @Override
        public final Builder extendedKeyUsage(Collection<ExtendedKeyUsage> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageListCopier.copy(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(ExtendedKeyUsage ... extendedKeyUsage) {
            this.extendedKeyUsage(Arrays.asList(extendedKeyUsage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(Consumer<ExtendedKeyUsage.Builder> ... extendedKeyUsage) {
            this.extendedKeyUsage(Stream.of(extendedKeyUsage).map(c -> (ExtendedKeyUsage)((ExtendedKeyUsage.Builder)ExtendedKeyUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KeyUsage.Builder getKeyUsage() {
            return this.keyUsage != null ? this.keyUsage.toBuilder() : null;
        }

        public final void setKeyUsage(KeyUsage.BuilderImpl keyUsage) {
            this.keyUsage = keyUsage != null ? keyUsage.build() : null;
        }

        @Override
        public final Builder keyUsage(KeyUsage keyUsage) {
            this.keyUsage = keyUsage;
            return this;
        }

        public final List<GeneralName.Builder> getSubjectAlternativeNames() {
            List<GeneralName.Builder> result = GeneralNameListCopier.copyToBuilder(this.subjectAlternativeNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjectAlternativeNames(Collection<GeneralName.BuilderImpl> subjectAlternativeNames) {
            this.subjectAlternativeNames = GeneralNameListCopier.copyFromBuilder(subjectAlternativeNames);
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<GeneralName> subjectAlternativeNames) {
            this.subjectAlternativeNames = GeneralNameListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(GeneralName ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(Consumer<GeneralName.Builder> ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Stream.of(subjectAlternativeNames).map(c -> (GeneralName)((GeneralName.Builder)GeneralName.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CustomExtension.Builder> getCustomExtensions() {
            List<CustomExtension.Builder> result = CustomExtensionListCopier.copyToBuilder(this.customExtensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomExtensions(Collection<CustomExtension.BuilderImpl> customExtensions) {
            this.customExtensions = CustomExtensionListCopier.copyFromBuilder(customExtensions);
        }

        @Override
        public final Builder customExtensions(Collection<CustomExtension> customExtensions) {
            this.customExtensions = CustomExtensionListCopier.copy(customExtensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customExtensions(CustomExtension ... customExtensions) {
            this.customExtensions(Arrays.asList(customExtensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customExtensions(Consumer<CustomExtension.Builder> ... customExtensions) {
            this.customExtensions(Stream.of(customExtensions).map(c -> (CustomExtension)((CustomExtension.Builder)CustomExtension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Extensions build() {
            return new Extensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Extensions> {
        public Builder certificatePolicies(Collection<PolicyInformation> var1);

        public Builder certificatePolicies(PolicyInformation ... var1);

        public Builder certificatePolicies(Consumer<PolicyInformation.Builder> ... var1);

        public Builder extendedKeyUsage(Collection<ExtendedKeyUsage> var1);

        public Builder extendedKeyUsage(ExtendedKeyUsage ... var1);

        public Builder extendedKeyUsage(Consumer<ExtendedKeyUsage.Builder> ... var1);

        public Builder keyUsage(KeyUsage var1);

        default public Builder keyUsage(Consumer<KeyUsage.Builder> keyUsage) {
            return this.keyUsage((KeyUsage)((KeyUsage.Builder)KeyUsage.builder().applyMutation(keyUsage)).build());
        }

        public Builder subjectAlternativeNames(Collection<GeneralName> var1);

        public Builder subjectAlternativeNames(GeneralName ... var1);

        public Builder subjectAlternativeNames(Consumer<GeneralName.Builder> ... var1);

        public Builder customExtensions(Collection<CustomExtension> var1);

        public Builder customExtensions(CustomExtension ... var1);

        public Builder customExtensions(Consumer<CustomExtension.Builder> ... var1);
    }
}

