/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyStorageSecurityStandard {
    FIPS_140_2_LEVEL_2_OR_HIGHER("FIPS_140_2_LEVEL_2_OR_HIGHER"),
    FIPS_140_2_LEVEL_3_OR_HIGHER("FIPS_140_2_LEVEL_3_OR_HIGHER"),
    CCPC_LEVEL_1_OR_HIGHER("CCPC_LEVEL_1_OR_HIGHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyStorageSecurityStandard> VALUE_MAP;
    private final String value;

    private KeyStorageSecurityStandard(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyStorageSecurityStandard fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyStorageSecurityStandard> knownValues() {
        EnumSet<KeyStorageSecurityStandard> knownValues = EnumSet.allOf(KeyStorageSecurityStandard.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyStorageSecurityStandard.class, KeyStorageSecurityStandard::toString);
    }
}

