/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AccessMethodType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessMethod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessMethod> {
    private static final SdkField<String> CUSTOM_OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomObjectIdentifier").getter(AccessMethod.getter(AccessMethod::customObjectIdentifier)).setter(AccessMethod.setter(Builder::customObjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomObjectIdentifier").build()}).build();
    private static final SdkField<String> ACCESS_METHOD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessMethodType").getter(AccessMethod.getter(AccessMethod::accessMethodTypeAsString)).setter(AccessMethod.setter(Builder::accessMethodType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessMethodType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_OBJECT_IDENTIFIER_FIELD, ACCESS_METHOD_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomObjectIdentifier", CUSTOM_OBJECT_IDENTIFIER_FIELD);
            this.put("AccessMethodType", ACCESS_METHOD_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String customObjectIdentifier;
    private final String accessMethodType;

    private AccessMethod(BuilderImpl builder) {
        this.customObjectIdentifier = builder.customObjectIdentifier;
        this.accessMethodType = builder.accessMethodType;
    }

    public final String customObjectIdentifier() {
        return this.customObjectIdentifier;
    }

    public final AccessMethodType accessMethodType() {
        return AccessMethodType.fromValue(this.accessMethodType);
    }

    public final String accessMethodTypeAsString() {
        return this.accessMethodType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customObjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessMethodTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessMethod)) {
            return false;
        }
        AccessMethod other = (AccessMethod)obj;
        return Objects.equals(this.customObjectIdentifier(), other.customObjectIdentifier()) && Objects.equals(this.accessMethodTypeAsString(), other.accessMethodTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessMethod").add("CustomObjectIdentifier", (Object)this.customObjectIdentifier()).add("AccessMethodType", (Object)this.accessMethodTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customObjectIdentifier()));
            }
            case "AccessMethodType": {
                return Optional.ofNullable(clazz.cast(this.accessMethodTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccessMethod, T> g) {
        return obj -> g.apply((AccessMethod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customObjectIdentifier;
        private String accessMethodType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessMethod model) {
            this.customObjectIdentifier(model.customObjectIdentifier);
            this.accessMethodType(model.accessMethodType);
        }

        public final String getCustomObjectIdentifier() {
            return this.customObjectIdentifier;
        }

        public final void setCustomObjectIdentifier(String customObjectIdentifier) {
            this.customObjectIdentifier = customObjectIdentifier;
        }

        @Override
        public final Builder customObjectIdentifier(String customObjectIdentifier) {
            this.customObjectIdentifier = customObjectIdentifier;
            return this;
        }

        public final String getAccessMethodType() {
            return this.accessMethodType;
        }

        public final void setAccessMethodType(String accessMethodType) {
            this.accessMethodType = accessMethodType;
        }

        @Override
        public final Builder accessMethodType(String accessMethodType) {
            this.accessMethodType = accessMethodType;
            return this;
        }

        @Override
        public final Builder accessMethodType(AccessMethodType accessMethodType) {
            this.accessMethodType(accessMethodType == null ? null : accessMethodType.toString());
            return this;
        }

        public AccessMethod build() {
            return new AccessMethod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessMethod> {
        public Builder customObjectIdentifier(String var1);

        public Builder accessMethodType(String var1);

        public Builder accessMethodType(AccessMethodType var1);
    }
}

