/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a <code>PolicyInformation</code> qualifier. Amazon Web Services Private CA supports the <a
 * href="https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4">certification practice statement (CPS)
 * qualifier</a> defined in RFC 5280.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Qualifier implements SdkPojo, Serializable, ToCopyableBuilder<Qualifier.Builder, Qualifier> {
    private static final SdkField<String> CPS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CpsUri")
            .getter(getter(Qualifier::cpsUri)).setter(setter(Builder::cpsUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpsUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPS_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cpsUri;

    private Qualifier(BuilderImpl builder) {
        this.cpsUri = builder.cpsUri;
    }

    /**
     * <p>
     * Contains a pointer to a certification practice statement (CPS) published by the CA.
     * </p>
     * 
     * @return Contains a pointer to a certification practice statement (CPS) published by the CA.
     */
    public final String cpsUri() {
        return cpsUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpsUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Qualifier)) {
            return false;
        }
        Qualifier other = (Qualifier) obj;
        return Objects.equals(cpsUri(), other.cpsUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Qualifier").add("CpsUri", cpsUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CpsUri":
            return Optional.ofNullable(clazz.cast(cpsUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Qualifier, T> g) {
        return obj -> g.apply((Qualifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Qualifier> {
        /**
         * <p>
         * Contains a pointer to a certification practice statement (CPS) published by the CA.
         * </p>
         * 
         * @param cpsUri
         *        Contains a pointer to a certification practice statement (CPS) published by the CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpsUri(String cpsUri);
    }

    static final class BuilderImpl implements Builder {
        private String cpsUri;

        private BuilderImpl() {
        }

        private BuilderImpl(Qualifier model) {
            cpsUri(model.cpsUri);
        }

        public final String getCpsUri() {
            return cpsUri;
        }

        public final void setCpsUri(String cpsUri) {
            this.cpsUri = cpsUri;
        }

        @Override
        public final Builder cpsUri(String cpsUri) {
            this.cpsUri = cpsUri;
            return this;
        }

        @Override
        public Qualifier build() {
            return new Qualifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
