/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.waiters.AcmPcaWaiter;
import software.amazon.awssdk.services.acmpca.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultAcmPcaWaiter
implements AcmPcaWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final AcmPcaClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetCertificateAuthorityCsrResponse> certificateAuthorityCSRCreatedWaiter;
    private final Waiter<GetCertificateResponse> certificateIssuedWaiter;
    private final Waiter<DescribeCertificateAuthorityAuditReportResponse> auditReportCreatedWaiter;

    private DefaultAcmPcaWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AcmPcaClient)AcmPcaClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.certificateAuthorityCSRCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetCertificateAuthorityCsrResponse.class).acceptors(DefaultAcmPcaWaiter.certificateAuthorityCSRCreatedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaWaiter.certificateAuthorityCSRCreatedWaiterConfig(builder.overrideConfiguration))).build();
        this.certificateIssuedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetCertificateResponse.class).acceptors(DefaultAcmPcaWaiter.certificateIssuedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaWaiter.certificateIssuedWaiterConfig(builder.overrideConfiguration))).build();
        this.auditReportCreatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCertificateAuthorityAuditReportResponse.class).acceptors(DefaultAcmPcaWaiter.auditReportCreatedWaiterAcceptors())).overrideConfiguration(DefaultAcmPcaWaiter.auditReportCreatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeCertificateAuthorityAuditReportResponse> waitUntilAuditReportCreated(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest) {
        return this.auditReportCreatedWaiter.run(() -> this.client.describeCertificateAuthorityAuditReport(this.applyWaitersUserAgent(describeCertificateAuthorityAuditReportRequest)));
    }

    @Override
    public WaiterResponse<DescribeCertificateAuthorityAuditReportResponse> waitUntilAuditReportCreated(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.auditReportCreatedWaiter.run(() -> this.client.describeCertificateAuthorityAuditReport(this.applyWaitersUserAgent(describeCertificateAuthorityAuditReportRequest)), DefaultAcmPcaWaiter.auditReportCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetCertificateAuthorityCsrResponse> waitUntilCertificateAuthorityCSRCreated(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) {
        return this.certificateAuthorityCSRCreatedWaiter.run(() -> this.client.getCertificateAuthorityCsr(this.applyWaitersUserAgent(getCertificateAuthorityCsrRequest)));
    }

    @Override
    public WaiterResponse<GetCertificateAuthorityCsrResponse> waitUntilCertificateAuthorityCSRCreated(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.certificateAuthorityCSRCreatedWaiter.run(() -> this.client.getCertificateAuthorityCsr(this.applyWaitersUserAgent(getCertificateAuthorityCsrRequest)), DefaultAcmPcaWaiter.certificateAuthorityCSRCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetCertificateResponse> waitUntilCertificateIssued(GetCertificateRequest getCertificateRequest) {
        return this.certificateIssuedWaiter.run(() -> this.client.getCertificate(this.applyWaitersUserAgent(getCertificateRequest)));
    }

    @Override
    public WaiterResponse<GetCertificateResponse> waitUntilCertificateIssued(GetCertificateRequest getCertificateRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.certificateIssuedWaiter.run(() -> this.client.getCertificate(this.applyWaitersUserAgent(getCertificateRequest)), DefaultAcmPcaWaiter.certificateIssuedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>> certificateAuthorityCSRCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>> result = new ArrayList<WaiterAcceptor<? super GetCertificateAuthorityCsrResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaWaiter.errorCode(error), "RequestInProgressException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetCertificateResponse>> certificateIssuedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetCertificateResponse>> result = new ArrayList<WaiterAcceptor<? super GetCertificateResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultAcmPcaWaiter.errorCode(error), "RequestInProgressException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>> auditReportCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCertificateAuthorityAuditReportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AuditReportStatus").value(), "SUCCESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("AuditReportStatus").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration certificateAuthorityCSRCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration certificateIssuedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration auditReportCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AcmPcaWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AcmPcaRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AcmPcaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AcmPcaWaiter.Builder {
        private AcmPcaClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public AcmPcaWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AcmPcaWaiter.Builder client(AcmPcaClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AcmPcaWaiter build() {
            return new DefaultAcmPcaWaiter(this);
        }
    }
}

