/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ASN1Subject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ASN1Subject> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(ASN1Subject.getter(ASN1Subject::country)).setter(ASN1Subject.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Organization").getter(ASN1Subject.getter(ASN1Subject::organization)).setter(ASN1Subject.setter(Builder::organization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnit").getter(ASN1Subject.getter(ASN1Subject::organizationalUnit)).setter(ASN1Subject.setter(Builder::organizationalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build()}).build();
    private static final SdkField<String> DISTINGUISHED_NAME_QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistinguishedNameQualifier").getter(ASN1Subject.getter(ASN1Subject::distinguishedNameQualifier)).setter(ASN1Subject.setter(Builder::distinguishedNameQualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedNameQualifier").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ASN1Subject.getter(ASN1Subject::state)).setter(ASN1Subject.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommonName").getter(ASN1Subject.getter(ASN1Subject::commonName)).setter(ASN1Subject.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(ASN1Subject.getter(ASN1Subject::serialNumber)).setter(ASN1Subject.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()}).build();
    private static final SdkField<String> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locality").getter(ASN1Subject.getter(ASN1Subject::locality)).setter(ASN1Subject.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(ASN1Subject.getter(ASN1Subject::title)).setter(ASN1Subject.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(ASN1Subject.getter(ASN1Subject::surname)).setter(ASN1Subject.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(ASN1Subject.getter(ASN1Subject::givenName)).setter(ASN1Subject.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<String> INITIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Initials").getter(ASN1Subject.getter(ASN1Subject::initials)).setter(ASN1Subject.setter(Builder::initials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()}).build();
    private static final SdkField<String> PSEUDONYM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pseudonym").getter(ASN1Subject.getter(ASN1Subject::pseudonym)).setter(ASN1Subject.setter(Builder::pseudonym)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pseudonym").build()}).build();
    private static final SdkField<String> GENERATION_QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationQualifier").getter(ASN1Subject.getter(ASN1Subject::generationQualifier)).setter(ASN1Subject.setter(Builder::generationQualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationQualifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, ORGANIZATION_FIELD, ORGANIZATIONAL_UNIT_FIELD, DISTINGUISHED_NAME_QUALIFIER_FIELD, STATE_FIELD, COMMON_NAME_FIELD, SERIAL_NUMBER_FIELD, LOCALITY_FIELD, TITLE_FIELD, SURNAME_FIELD, GIVEN_NAME_FIELD, INITIALS_FIELD, PSEUDONYM_FIELD, GENERATION_QUALIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String country;
    private final String organization;
    private final String organizationalUnit;
    private final String distinguishedNameQualifier;
    private final String state;
    private final String commonName;
    private final String serialNumber;
    private final String locality;
    private final String title;
    private final String surname;
    private final String givenName;
    private final String initials;
    private final String pseudonym;
    private final String generationQualifier;

    private ASN1Subject(BuilderImpl builder) {
        this.country = builder.country;
        this.organization = builder.organization;
        this.organizationalUnit = builder.organizationalUnit;
        this.distinguishedNameQualifier = builder.distinguishedNameQualifier;
        this.state = builder.state;
        this.commonName = builder.commonName;
        this.serialNumber = builder.serialNumber;
        this.locality = builder.locality;
        this.title = builder.title;
        this.surname = builder.surname;
        this.givenName = builder.givenName;
        this.initials = builder.initials;
        this.pseudonym = builder.pseudonym;
        this.generationQualifier = builder.generationQualifier;
    }

    public final String country() {
        return this.country;
    }

    public final String organization() {
        return this.organization;
    }

    public final String organizationalUnit() {
        return this.organizationalUnit;
    }

    public final String distinguishedNameQualifier() {
        return this.distinguishedNameQualifier;
    }

    public final String state() {
        return this.state;
    }

    public final String commonName() {
        return this.commonName;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String locality() {
        return this.locality;
    }

    public final String title() {
        return this.title;
    }

    public final String surname() {
        return this.surname;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final String initials() {
        return this.initials;
    }

    public final String pseudonym() {
        return this.pseudonym;
    }

    public final String generationQualifier() {
        return this.generationQualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.distinguishedNameQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.locality());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.initials());
        hashCode = 31 * hashCode + Objects.hashCode(this.pseudonym());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationQualifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ASN1Subject)) {
            return false;
        }
        ASN1Subject other = (ASN1Subject)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.organization(), other.organization()) && Objects.equals(this.organizationalUnit(), other.organizationalUnit()) && Objects.equals(this.distinguishedNameQualifier(), other.distinguishedNameQualifier()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.locality(), other.locality()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.givenName(), other.givenName()) && Objects.equals(this.initials(), other.initials()) && Objects.equals(this.pseudonym(), other.pseudonym()) && Objects.equals(this.generationQualifier(), other.generationQualifier());
    }

    public final String toString() {
        return ToString.builder((String)"ASN1Subject").add("Country", (Object)this.country()).add("Organization", (Object)this.organization()).add("OrganizationalUnit", (Object)this.organizationalUnit()).add("DistinguishedNameQualifier", (Object)this.distinguishedNameQualifier()).add("State", (Object)this.state()).add("CommonName", (Object)this.commonName()).add("SerialNumber", (Object)this.serialNumber()).add("Locality", (Object)this.locality()).add("Title", (Object)this.title()).add("Surname", (Object)this.surname()).add("GivenName", (Object)this.givenName()).add("Initials", (Object)this.initials()).add("Pseudonym", (Object)this.pseudonym()).add("GenerationQualifier", (Object)this.generationQualifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
            case "OrganizationalUnit": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnit()));
            }
            case "DistinguishedNameQualifier": {
                return Optional.ofNullable(clazz.cast(this.distinguishedNameQualifier()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "CommonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "Initials": {
                return Optional.ofNullable(clazz.cast(this.initials()));
            }
            case "Pseudonym": {
                return Optional.ofNullable(clazz.cast(this.pseudonym()));
            }
            case "GenerationQualifier": {
                return Optional.ofNullable(clazz.cast(this.generationQualifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ASN1Subject, T> g) {
        return obj -> g.apply((ASN1Subject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private String organization;
        private String organizationalUnit;
        private String distinguishedNameQualifier;
        private String state;
        private String commonName;
        private String serialNumber;
        private String locality;
        private String title;
        private String surname;
        private String givenName;
        private String initials;
        private String pseudonym;
        private String generationQualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ASN1Subject model) {
            this.country(model.country);
            this.organization(model.organization);
            this.organizationalUnit(model.organizationalUnit);
            this.distinguishedNameQualifier(model.distinguishedNameQualifier);
            this.state(model.state);
            this.commonName(model.commonName);
            this.serialNumber(model.serialNumber);
            this.locality(model.locality);
            this.title(model.title);
            this.surname(model.surname);
            this.givenName(model.givenName);
            this.initials(model.initials);
            this.pseudonym(model.pseudonym);
            this.generationQualifier(model.generationQualifier);
        }

        public final String getCountry() {
            return this.country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        public final String getOrganization() {
            return this.organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        public final String getOrganizationalUnit() {
            return this.organizationalUnit;
        }

        @Override
        public final Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public final void setOrganizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
        }

        public final String getDistinguishedNameQualifier() {
            return this.distinguishedNameQualifier;
        }

        @Override
        public final Builder distinguishedNameQualifier(String distinguishedNameQualifier) {
            this.distinguishedNameQualifier = distinguishedNameQualifier;
            return this;
        }

        public final void setDistinguishedNameQualifier(String distinguishedNameQualifier) {
            this.distinguishedNameQualifier = distinguishedNameQualifier;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getLocality() {
            return this.locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getSurname() {
            return this.surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getInitials() {
            return this.initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        public final String getPseudonym() {
            return this.pseudonym;
        }

        @Override
        public final Builder pseudonym(String pseudonym) {
            this.pseudonym = pseudonym;
            return this;
        }

        public final void setPseudonym(String pseudonym) {
            this.pseudonym = pseudonym;
        }

        public final String getGenerationQualifier() {
            return this.generationQualifier;
        }

        @Override
        public final Builder generationQualifier(String generationQualifier) {
            this.generationQualifier = generationQualifier;
            return this;
        }

        public final void setGenerationQualifier(String generationQualifier) {
            this.generationQualifier = generationQualifier;
        }

        public ASN1Subject build() {
            return new ASN1Subject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ASN1Subject> {
        public Builder country(String var1);

        public Builder organization(String var1);

        public Builder organizationalUnit(String var1);

        public Builder distinguishedNameQualifier(String var1);

        public Builder state(String var1);

        public Builder commonName(String var1);

        public Builder serialNumber(String var1);

        public Builder locality(String var1);

        public Builder title(String var1);

        public Builder surname(String var1);

        public Builder givenName(String var1);

        public Builder initials(String var1);

        public Builder pseudonym(String var1);

        public Builder generationQualifier(String var1);
    }
}

