/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportCertificateAuthorityCertificateRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, ImportCertificateAuthorityCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityArn").getter(ImportCertificateAuthorityCertificateRequest.getter(ImportCertificateAuthorityCertificateRequest::certificateAuthorityArn)).setter(ImportCertificateAuthorityCertificateRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Certificate").getter(ImportCertificateAuthorityCertificateRequest.getter(ImportCertificateAuthorityCertificateRequest::certificate)).setter(ImportCertificateAuthorityCertificateRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<SdkBytes> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("CertificateChain").getter(ImportCertificateAuthorityCertificateRequest.getter(ImportCertificateAuthorityCertificateRequest::certificateChain)).setter(ImportCertificateAuthorityCertificateRequest.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD));
    private final String certificateAuthorityArn;
    private final SdkBytes certificate;
    private final SdkBytes certificateChain;

    private ImportCertificateAuthorityCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
    }

    public final String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public final SdkBytes certificate() {
        return this.certificate;
    }

    public final SdkBytes certificateChain() {
        return this.certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateAuthorityCertificateRequest)) {
            return false;
        }
        ImportCertificateAuthorityCertificateRequest other = (ImportCertificateAuthorityCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain());
    }

    public final String toString() {
        return ToString.builder((String)"ImportCertificateAuthorityCertificateRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("Certificate", (Object)this.certificate()).add("CertificateChain", (Object)this.certificateChain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateAuthorityCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateAuthorityCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private SdkBytes certificate;
        private SdkBytes certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateAuthorityCertificateRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final ByteBuffer getCertificate() {
            return this.certificate == null ? null : this.certificate.asByteBuffer();
        }

        @Override
        public final Builder certificate(SdkBytes certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(ByteBuffer certificate) {
            this.certificate(certificate == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificate));
        }

        public final ByteBuffer getCertificateChain() {
            return this.certificateChain == null ? null : this.certificateChain.asByteBuffer();
        }

        @Override
        public final Builder certificateChain(SdkBytes certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(ByteBuffer certificateChain) {
            this.certificateChain(certificateChain == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)certificateChain));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateAuthorityCertificateRequest build() {
            return new ImportCertificateAuthorityCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportCertificateAuthorityCertificateRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder certificate(SdkBytes var1);

        public Builder certificateChain(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

