/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrlConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CrlConfiguration.getter(CrlConfiguration::enabled)).setter(CrlConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Integer> EXPIRATION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationInDays").getter(CrlConfiguration.getter(CrlConfiguration::expirationInDays)).setter(CrlConfiguration.setter(Builder::expirationInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationInDays").build()}).build();
    private static final SdkField<String> CUSTOM_CNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomCname").getter(CrlConfiguration.getter(CrlConfiguration::customCname)).setter(CrlConfiguration.setter(Builder::customCname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCname").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(CrlConfiguration.getter(CrlConfiguration::s3BucketName)).setter(CrlConfiguration.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, EXPIRATION_IN_DAYS_FIELD, CUSTOM_CNAME_FIELD, S3_BUCKET_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer expirationInDays;
    private final String customCname;
    private final String s3BucketName;

    private CrlConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.expirationInDays = builder.expirationInDays;
        this.customCname = builder.customCname;
        this.s3BucketName = builder.s3BucketName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer expirationInDays() {
        return this.expirationInDays;
    }

    public String customCname() {
        return this.customCname;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.customCname());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrlConfiguration)) {
            return false;
        }
        CrlConfiguration other = (CrlConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.expirationInDays(), other.expirationInDays()) && Objects.equals(this.customCname(), other.customCname()) && Objects.equals(this.s3BucketName(), other.s3BucketName());
    }

    public String toString() {
        return ToString.builder((String)"CrlConfiguration").add("Enabled", (Object)this.enabled()).add("ExpirationInDays", (Object)this.expirationInDays()).add("CustomCname", (Object)this.customCname()).add("S3BucketName", (Object)this.s3BucketName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ExpirationInDays": {
                return Optional.ofNullable(clazz.cast(this.expirationInDays()));
            }
            case "CustomCname": {
                return Optional.ofNullable(clazz.cast(this.customCname()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrlConfiguration, T> g) {
        return obj -> g.apply((CrlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer expirationInDays;
        private String customCname;
        private String s3BucketName;

        private BuilderImpl() {
        }

        private BuilderImpl(CrlConfiguration model) {
            this.enabled(model.enabled);
            this.expirationInDays(model.expirationInDays);
            this.customCname(model.customCname);
            this.s3BucketName(model.s3BucketName);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getExpirationInDays() {
            return this.expirationInDays;
        }

        @Override
        public final Builder expirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
            return this;
        }

        public final void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        public final String getCustomCname() {
            return this.customCname;
        }

        @Override
        public final Builder customCname(String customCname) {
            this.customCname = customCname;
            return this;
        }

        public final void setCustomCname(String customCname) {
            this.customCname = customCname;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public CrlConfiguration build() {
            return new CrlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrlConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder expirationInDays(Integer var1);

        public Builder customCname(String var1);

        public Builder s3BucketName(String var1);
    }
}

