/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.ASN1Subject;
import software.amazon.awssdk.services.acmpca.model.KeyAlgorithm;
import software.amazon.awssdk.services.acmpca.model.SigningAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateAuthorityConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateAuthorityConfiguration> {
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(CertificateAuthorityConfiguration.getter(CertificateAuthorityConfiguration::keyAlgorithmAsString)).setter(CertificateAuthorityConfiguration.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(CertificateAuthorityConfiguration.getter(CertificateAuthorityConfiguration::signingAlgorithmAsString)).setter(CertificateAuthorityConfiguration.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<ASN1Subject> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subject").getter(CertificateAuthorityConfiguration.getter(CertificateAuthorityConfiguration::subject)).setter(CertificateAuthorityConfiguration.setter(Builder::subject)).constructor(ASN1Subject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ALGORITHM_FIELD, SIGNING_ALGORITHM_FIELD, SUBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyAlgorithm;
    private final String signingAlgorithm;
    private final ASN1Subject subject;

    private CertificateAuthorityConfiguration(BuilderImpl builder) {
        this.keyAlgorithm = builder.keyAlgorithm;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.subject = builder.subject;
    }

    public KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public SigningAlgorithm signingAlgorithm() {
        return SigningAlgorithm.fromValue(this.signingAlgorithm);
    }

    public String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public ASN1Subject subject() {
        return this.subject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateAuthorityConfiguration)) {
            return false;
        }
        CertificateAuthorityConfiguration other = (CertificateAuthorityConfiguration)obj;
        return Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString()) && Objects.equals(this.subject(), other.subject());
    }

    public String toString() {
        return ToString.builder((String)"CertificateAuthorityConfiguration").add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).add("Subject", (Object)this.subject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateAuthorityConfiguration, T> g) {
        return obj -> g.apply((CertificateAuthorityConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyAlgorithm;
        private String signingAlgorithm;
        private ASN1Subject subject;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateAuthorityConfiguration model) {
            this.keyAlgorithm(model.keyAlgorithm);
            this.signingAlgorithm(model.signingAlgorithm);
            this.subject(model.subject);
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm == null ? null : signingAlgorithm.toString());
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public final ASN1Subject.Builder getSubject() {
            return this.subject != null ? this.subject.toBuilder() : null;
        }

        @Override
        public final Builder subject(ASN1Subject subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(ASN1Subject.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        public CertificateAuthorityConfiguration build() {
            return new CertificateAuthorityConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateAuthorityConfiguration> {
        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithm var1);

        public Builder subject(ASN1Subject var1);

        default public Builder subject(Consumer<ASN1Subject.Builder> subject) {
            return this.subject((ASN1Subject)((ASN1Subject.Builder)ASN1Subject.builder().applyMutation(subject)).build());
        }
    }
}

