/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.acm.AcmAsyncClient;
import software.amazon.awssdk.services.acm.AcmServiceClientConfiguration;
import software.amazon.awssdk.services.acm.internal.AcmServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.acm.model.AccessDeniedException;
import software.amazon.awssdk.services.acm.model.AcmException;
import software.amazon.awssdk.services.acm.model.AddTagsToCertificateRequest;
import software.amazon.awssdk.services.acm.model.AddTagsToCertificateResponse;
import software.amazon.awssdk.services.acm.model.ConflictException;
import software.amazon.awssdk.services.acm.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.acm.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.acm.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.acm.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.acm.model.ExportCertificateRequest;
import software.amazon.awssdk.services.acm.model.ExportCertificateResponse;
import software.amazon.awssdk.services.acm.model.GetAccountConfigurationRequest;
import software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse;
import software.amazon.awssdk.services.acm.model.GetCertificateRequest;
import software.amazon.awssdk.services.acm.model.GetCertificateResponse;
import software.amazon.awssdk.services.acm.model.ImportCertificateRequest;
import software.amazon.awssdk.services.acm.model.ImportCertificateResponse;
import software.amazon.awssdk.services.acm.model.InvalidArgsException;
import software.amazon.awssdk.services.acm.model.InvalidArnException;
import software.amazon.awssdk.services.acm.model.InvalidDomainValidationOptionsException;
import software.amazon.awssdk.services.acm.model.InvalidParameterException;
import software.amazon.awssdk.services.acm.model.InvalidStateException;
import software.amazon.awssdk.services.acm.model.InvalidTagException;
import software.amazon.awssdk.services.acm.model.LimitExceededException;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;
import software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest;
import software.amazon.awssdk.services.acm.model.ListTagsForCertificateResponse;
import software.amazon.awssdk.services.acm.model.PutAccountConfigurationRequest;
import software.amazon.awssdk.services.acm.model.PutAccountConfigurationResponse;
import software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest;
import software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateResponse;
import software.amazon.awssdk.services.acm.model.RenewCertificateRequest;
import software.amazon.awssdk.services.acm.model.RenewCertificateResponse;
import software.amazon.awssdk.services.acm.model.RequestCertificateRequest;
import software.amazon.awssdk.services.acm.model.RequestCertificateResponse;
import software.amazon.awssdk.services.acm.model.RequestInProgressException;
import software.amazon.awssdk.services.acm.model.ResendValidationEmailRequest;
import software.amazon.awssdk.services.acm.model.ResendValidationEmailResponse;
import software.amazon.awssdk.services.acm.model.ResourceInUseException;
import software.amazon.awssdk.services.acm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acm.model.RevokeCertificateRequest;
import software.amazon.awssdk.services.acm.model.RevokeCertificateResponse;
import software.amazon.awssdk.services.acm.model.TagPolicyException;
import software.amazon.awssdk.services.acm.model.ThrottlingException;
import software.amazon.awssdk.services.acm.model.TooManyTagsException;
import software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsRequest;
import software.amazon.awssdk.services.acm.model.UpdateCertificateOptionsResponse;
import software.amazon.awssdk.services.acm.model.ValidationException;
import software.amazon.awssdk.services.acm.transform.AddTagsToCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.ExportCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.GetAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.GetCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.ImportCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.ListTagsForCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.PutAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.RemoveTagsFromCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.RenewCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.RequestCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.ResendValidationEmailRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.RevokeCertificateRequestMarshaller;
import software.amazon.awssdk.services.acm.transform.UpdateCertificateOptionsRequestMarshaller;
import software.amazon.awssdk.services.acm.waiters.AcmAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAcmAsyncClient
implements AcmAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAcmAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultAcmAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ACM#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AddTagsToCertificateResponse> addTagsToCertificate(AddTagsToCertificateRequest addTagsToCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsToCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, addTagsToCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddTagsToCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addTagsToCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$addTagsToCertificate$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$addTagsToCertificate$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$deleteCertificate$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$deleteCertificate$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(DescribeCertificateRequest describeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, describeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$describeCertificate$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$describeCertificate$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportCertificateResponse> exportCertificate(ExportCertificateRequest exportCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, exportCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExportCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$exportCertificate$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$exportCertificate$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccountConfigurationResponse> getAccountConfiguration(GetAccountConfigurationRequest getAccountConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAccountConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, getAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccountConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$getAccountConfiguration$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$getAccountConfiguration$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificateResponse> getCertificate(GetCertificateRequest getCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, getCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$getCertificate$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$getCertificate$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportCertificateResponse> importCertificate(ImportCertificateRequest importCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, importCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$importCertificate$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$importCertificate$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCertificatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, listCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$listCertificates$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$listCertificates$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForCertificateResponse> listTagsForCertificate(ListTagsForCertificateRequest listTagsForCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$listTagsForCertificate$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$listTagsForCertificate$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccountConfigurationResponse> putAccountConfiguration(PutAccountConfigurationRequest putAccountConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAccountConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, putAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAccountConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccountConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccountConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$putAccountConfiguration$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$putAccountConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveTagsFromCertificateResponse> removeTagsFromCertificate(RemoveTagsFromCertificateRequest removeTagsFromCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeTagsFromCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, removeTagsFromCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveTagsFromCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeTagsFromCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$removeTagsFromCertificate$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$removeTagsFromCertificate$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RenewCertificateResponse> renewCertificate(RenewCertificateRequest renewCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)renewCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, renewCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RenewCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RenewCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RenewCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RenewCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)renewCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$renewCertificate$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$renewCertificate$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RequestCertificateResponse> requestCertificate(RequestCertificateRequest requestCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)requestCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, requestCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RequestCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)requestCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$requestCertificate$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$requestCertificate$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResendValidationEmailResponse> resendValidationEmail(ResendValidationEmailRequest resendValidationEmailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resendValidationEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, resendValidationEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResendValidationEmail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResendValidationEmailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResendValidationEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ResendValidationEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resendValidationEmailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$resendValidationEmail$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$resendValidationEmail$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeCertificateResponse> revokeCertificate(RevokeCertificateRequest revokeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, revokeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$revokeCertificate$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$revokeCertificate$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCertificateOptionsResponse> updateCertificateOptions(UpdateCertificateOptionsRequest updateCertificateOptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCertificateOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmAsyncClient.resolveMetricPublishers(clientConfiguration, updateCertificateOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCertificateOptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCertificateOptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "TagPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "InvalidDomainValidationOptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDomainValidationOptionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDomainValidationOptionsException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCertificateOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCertificateOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCertificateOptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmAsyncClient.lambda$updateCertificateOptions$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmAsyncClient.lambda$updateCertificateOptions$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public AcmAsyncWaiter waiter() {
        return AcmAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final AcmServiceClientConfiguration serviceClientConfiguration() {
        return new AcmServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "acm";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AcmException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        AcmServiceClientConfigurationBuilder serviceConfigBuilder = new AcmServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCertificateOptions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCertificateOptions$62(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCertificateOptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeCertificate$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeCertificate$58(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resendValidationEmail$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resendValidationEmail$54(List metricPublishers, MetricCollector apiCallMetricCollector, ResendValidationEmailResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$requestCertificate$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$requestCertificate$50(List metricPublishers, MetricCollector apiCallMetricCollector, RequestCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$renewCertificate$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$renewCertificate$46(List metricPublishers, MetricCollector apiCallMetricCollector, RenewCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeTagsFromCertificate$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromCertificate$42(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveTagsFromCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccountConfiguration$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccountConfiguration$38(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccountConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForCertificate$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForCertificate$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCertificates$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCertificates$30(List metricPublishers, MetricCollector apiCallMetricCollector, ListCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importCertificate$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCertificate$26(List metricPublishers, MetricCollector apiCallMetricCollector, ImportCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificate$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccountConfiguration$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccountConfiguration$18(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccountConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportCertificate$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportCertificate$14(List metricPublishers, MetricCollector apiCallMetricCollector, ExportCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCertificate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificate$10(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCertificate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificate$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addTagsToCertificate$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToCertificate$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddTagsToCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

