/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationMethod {
    EMAIL("EMAIL"),
    DNS("DNS"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationMethod> VALUE_MAP;
    private final String value;

    private ValidationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationMethod> knownValues() {
        EnumSet<ValidationMethod> knownValues = EnumSet.allOf(ValidationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationMethod.class, ValidationMethod::toString);
    }
}

