/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.CertificateManagedBy;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateType;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageNamesCopier;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.KeyUsageName;
import software.amazon.awssdk.services.acm.model.KeyUsageNamesCopier;
import software.amazon.awssdk.services.acm.model.RenewalEligibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateSummary> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(CertificateSummary.getter(CertificateSummary::certificateArn)).setter(CertificateSummary.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CertificateSummary.getter(CertificateSummary::domainName)).setter(CertificateSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAME_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubjectAlternativeNameSummaries").getter(CertificateSummary.getter(CertificateSummary::subjectAlternativeNameSummaries)).setter(CertificateSummary.setter(Builder::subjectAlternativeNameSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNameSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_ADDITIONAL_SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasAdditionalSubjectAlternativeNames").getter(CertificateSummary.getter(CertificateSummary::hasAdditionalSubjectAlternativeNames)).setter(CertificateSummary.setter(Builder::hasAdditionalSubjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAdditionalSubjectAlternativeNames").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CertificateSummary.getter(CertificateSummary::statusAsString)).setter(CertificateSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CertificateSummary.getter(CertificateSummary::typeAsString)).setter(CertificateSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyAlgorithm").getter(CertificateSummary.getter(CertificateSummary::keyAlgorithmAsString)).setter(CertificateSummary.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<List<String>> KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyUsages").getter(CertificateSummary.getter(CertificateSummary::keyUsagesAsStrings)).setter(CertificateSummary.setter(Builder::keyUsagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXTENDED_KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtendedKeyUsages").getter(CertificateSummary.getter(CertificateSummary::extendedKeyUsagesAsStrings)).setter(CertificateSummary.setter(Builder::extendedKeyUsagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IN_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InUse").getter(CertificateSummary.getter(CertificateSummary::inUse)).setter(CertificateSummary.setter(Builder::inUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUse").build()}).build();
    private static final SdkField<Boolean> EXPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exported").getter(CertificateSummary.getter(CertificateSummary::exported)).setter(CertificateSummary.setter(Builder::exported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exported").build()}).build();
    private static final SdkField<String> RENEWAL_ELIGIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalEligibility").getter(CertificateSummary.getter(CertificateSummary::renewalEligibilityAsString)).setter(CertificateSummary.setter(Builder::renewalEligibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalEligibility").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotBefore").getter(CertificateSummary.getter(CertificateSummary::notBefore)).setter(CertificateSummary.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotAfter").getter(CertificateSummary.getter(CertificateSummary::notAfter)).setter(CertificateSummary.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CertificateSummary.getter(CertificateSummary::createdAt)).setter(CertificateSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IssuedAt").getter(CertificateSummary.getter(CertificateSummary::issuedAt)).setter(CertificateSummary.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()}).build();
    private static final SdkField<Instant> IMPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportedAt").getter(CertificateSummary.getter(CertificateSummary::importedAt)).setter(CertificateSummary.setter(Builder::importedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedAt").build()}).build();
    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RevokedAt").getter(CertificateSummary.getter(CertificateSummary::revokedAt)).setter(CertificateSummary.setter(Builder::revokedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedAt").build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(CertificateSummary.getter(CertificateSummary::managedByAsString)).setter(CertificateSummary.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, DOMAIN_NAME_FIELD, SUBJECT_ALTERNATIVE_NAME_SUMMARIES_FIELD, HAS_ADDITIONAL_SUBJECT_ALTERNATIVE_NAMES_FIELD, STATUS_FIELD, TYPE_FIELD, KEY_ALGORITHM_FIELD, KEY_USAGES_FIELD, EXTENDED_KEY_USAGES_FIELD, IN_USE_FIELD, EXPORTED_FIELD, RENEWAL_ELIGIBILITY_FIELD, NOT_BEFORE_FIELD, NOT_AFTER_FIELD, CREATED_AT_FIELD, ISSUED_AT_FIELD, IMPORTED_AT_FIELD, REVOKED_AT_FIELD, MANAGED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CertificateSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String domainName;
    private final List<String> subjectAlternativeNameSummaries;
    private final Boolean hasAdditionalSubjectAlternativeNames;
    private final String status;
    private final String type;
    private final String keyAlgorithm;
    private final List<String> keyUsages;
    private final List<String> extendedKeyUsages;
    private final Boolean inUse;
    private final Boolean exported;
    private final String renewalEligibility;
    private final Instant notBefore;
    private final Instant notAfter;
    private final Instant createdAt;
    private final Instant issuedAt;
    private final Instant importedAt;
    private final Instant revokedAt;
    private final String managedBy;

    private CertificateSummary(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
        this.subjectAlternativeNameSummaries = builder.subjectAlternativeNameSummaries;
        this.hasAdditionalSubjectAlternativeNames = builder.hasAdditionalSubjectAlternativeNames;
        this.status = builder.status;
        this.type = builder.type;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyUsages = builder.keyUsages;
        this.extendedKeyUsages = builder.extendedKeyUsages;
        this.inUse = builder.inUse;
        this.exported = builder.exported;
        this.renewalEligibility = builder.renewalEligibility;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.createdAt = builder.createdAt;
        this.issuedAt = builder.issuedAt;
        this.importedAt = builder.importedAt;
        this.revokedAt = builder.revokedAt;
        this.managedBy = builder.managedBy;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasSubjectAlternativeNameSummaries() {
        return this.subjectAlternativeNameSummaries != null && !(this.subjectAlternativeNameSummaries instanceof SdkAutoConstructList);
    }

    public final List<String> subjectAlternativeNameSummaries() {
        return this.subjectAlternativeNameSummaries;
    }

    public final Boolean hasAdditionalSubjectAlternativeNames() {
        return this.hasAdditionalSubjectAlternativeNames;
    }

    public final CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public final String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public final List<KeyUsageName> keyUsages() {
        return KeyUsageNamesCopier.copyStringToEnum(this.keyUsages);
    }

    public final boolean hasKeyUsages() {
        return this.keyUsages != null && !(this.keyUsages instanceof SdkAutoConstructList);
    }

    public final List<String> keyUsagesAsStrings() {
        return this.keyUsages;
    }

    public final List<ExtendedKeyUsageName> extendedKeyUsages() {
        return ExtendedKeyUsageNamesCopier.copyStringToEnum(this.extendedKeyUsages);
    }

    public final boolean hasExtendedKeyUsages() {
        return this.extendedKeyUsages != null && !(this.extendedKeyUsages instanceof SdkAutoConstructList);
    }

    public final List<String> extendedKeyUsagesAsStrings() {
        return this.extendedKeyUsages;
    }

    public final Boolean inUse() {
        return this.inUse;
    }

    public final Boolean exported() {
        return this.exported;
    }

    public final RenewalEligibility renewalEligibility() {
        return RenewalEligibility.fromValue(this.renewalEligibility);
    }

    public final String renewalEligibilityAsString() {
        return this.renewalEligibility;
    }

    public final Instant notBefore() {
        return this.notBefore;
    }

    public final Instant notAfter() {
        return this.notAfter;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant issuedAt() {
        return this.issuedAt;
    }

    public final Instant importedAt() {
        return this.importedAt;
    }

    public final Instant revokedAt() {
        return this.revokedAt;
    }

    public final CertificateManagedBy managedBy() {
        return CertificateManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNameSummaries() ? this.subjectAlternativeNameSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalSubjectAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyUsages() ? this.keyUsagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtendedKeyUsages() ? this.extendedKeyUsagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.exported());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalEligibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSummary)) {
            return false;
        }
        CertificateSummary other = (CertificateSummary)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.domainName(), other.domainName()) && this.hasSubjectAlternativeNameSummaries() == other.hasSubjectAlternativeNameSummaries() && Objects.equals(this.subjectAlternativeNameSummaries(), other.subjectAlternativeNameSummaries()) && Objects.equals(this.hasAdditionalSubjectAlternativeNames(), other.hasAdditionalSubjectAlternativeNames()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && this.hasKeyUsages() == other.hasKeyUsages() && Objects.equals(this.keyUsagesAsStrings(), other.keyUsagesAsStrings()) && this.hasExtendedKeyUsages() == other.hasExtendedKeyUsages() && Objects.equals(this.extendedKeyUsagesAsStrings(), other.extendedKeyUsagesAsStrings()) && Objects.equals(this.inUse(), other.inUse()) && Objects.equals(this.exported(), other.exported()) && Objects.equals(this.renewalEligibilityAsString(), other.renewalEligibilityAsString()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.importedAt(), other.importedAt()) && Objects.equals(this.revokedAt(), other.revokedAt()) && Objects.equals(this.managedByAsString(), other.managedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateSummary").add("CertificateArn", (Object)this.certificateArn()).add("DomainName", (Object)this.domainName()).add("SubjectAlternativeNameSummaries", this.hasSubjectAlternativeNameSummaries() ? this.subjectAlternativeNameSummaries() : null).add("HasAdditionalSubjectAlternativeNames", (Object)this.hasAdditionalSubjectAlternativeNames()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("KeyUsages", this.hasKeyUsages() ? this.keyUsagesAsStrings() : null).add("ExtendedKeyUsages", this.hasExtendedKeyUsages() ? this.extendedKeyUsagesAsStrings() : null).add("InUse", (Object)this.inUse()).add("Exported", (Object)this.exported()).add("RenewalEligibility", (Object)this.renewalEligibilityAsString()).add("NotBefore", (Object)this.notBefore()).add("NotAfter", (Object)this.notAfter()).add("CreatedAt", (Object)this.createdAt()).add("IssuedAt", (Object)this.issuedAt()).add("ImportedAt", (Object)this.importedAt()).add("RevokedAt", (Object)this.revokedAt()).add("ManagedBy", (Object)this.managedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SubjectAlternativeNameSummaries": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNameSummaries()));
            }
            case "HasAdditionalSubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.hasAdditionalSubjectAlternativeNames()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "KeyUsages": {
                return Optional.ofNullable(clazz.cast(this.keyUsagesAsStrings()));
            }
            case "ExtendedKeyUsages": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsagesAsStrings()));
            }
            case "InUse": {
                return Optional.ofNullable(clazz.cast(this.inUse()));
            }
            case "Exported": {
                return Optional.ofNullable(clazz.cast(this.exported()));
            }
            case "RenewalEligibility": {
                return Optional.ofNullable(clazz.cast(this.renewalEligibilityAsString()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "ImportedAt": {
                return Optional.ofNullable(clazz.cast(this.importedAt()));
            }
            case "RevokedAt": {
                return Optional.ofNullable(clazz.cast(this.revokedAt()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SubjectAlternativeNameSummaries", SUBJECT_ALTERNATIVE_NAME_SUMMARIES_FIELD);
        map.put("HasAdditionalSubjectAlternativeNames", HAS_ADDITIONAL_SUBJECT_ALTERNATIVE_NAMES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("KeyAlgorithm", KEY_ALGORITHM_FIELD);
        map.put("KeyUsages", KEY_USAGES_FIELD);
        map.put("ExtendedKeyUsages", EXTENDED_KEY_USAGES_FIELD);
        map.put("InUse", IN_USE_FIELD);
        map.put("Exported", EXPORTED_FIELD);
        map.put("RenewalEligibility", RENEWAL_ELIGIBILITY_FIELD);
        map.put("NotBefore", NOT_BEFORE_FIELD);
        map.put("NotAfter", NOT_AFTER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("ImportedAt", IMPORTED_AT_FIELD);
        map.put("RevokedAt", REVOKED_AT_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateSummary, T> g) {
        return obj -> g.apply((CertificateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;
        private List<String> subjectAlternativeNameSummaries = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasAdditionalSubjectAlternativeNames;
        private String status;
        private String type;
        private String keyAlgorithm;
        private List<String> keyUsages = DefaultSdkAutoConstructList.getInstance();
        private List<String> extendedKeyUsages = DefaultSdkAutoConstructList.getInstance();
        private Boolean inUse;
        private Boolean exported;
        private String renewalEligibility;
        private Instant notBefore;
        private Instant notAfter;
        private Instant createdAt;
        private Instant issuedAt;
        private Instant importedAt;
        private Instant revokedAt;
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSummary model) {
            this.certificateArn(model.certificateArn);
            this.domainName(model.domainName);
            this.subjectAlternativeNameSummaries(model.subjectAlternativeNameSummaries);
            this.hasAdditionalSubjectAlternativeNames(model.hasAdditionalSubjectAlternativeNames);
            this.status(model.status);
            this.type(model.type);
            this.keyAlgorithm(model.keyAlgorithm);
            this.keyUsagesWithStrings(model.keyUsages);
            this.extendedKeyUsagesWithStrings(model.extendedKeyUsages);
            this.inUse(model.inUse);
            this.exported(model.exported);
            this.renewalEligibility(model.renewalEligibility);
            this.notBefore(model.notBefore);
            this.notAfter(model.notAfter);
            this.createdAt(model.createdAt);
            this.issuedAt(model.issuedAt);
            this.importedAt(model.importedAt);
            this.revokedAt(model.revokedAt);
            this.managedBy(model.managedBy);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getSubjectAlternativeNameSummaries() {
            if (this.subjectAlternativeNameSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjectAlternativeNameSummaries;
        }

        public final void setSubjectAlternativeNameSummaries(Collection<String> subjectAlternativeNameSummaries) {
            this.subjectAlternativeNameSummaries = DomainListCopier.copy(subjectAlternativeNameSummaries);
        }

        @Override
        public final Builder subjectAlternativeNameSummaries(Collection<String> subjectAlternativeNameSummaries) {
            this.subjectAlternativeNameSummaries = DomainListCopier.copy(subjectAlternativeNameSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNameSummaries(String ... subjectAlternativeNameSummaries) {
            this.subjectAlternativeNameSummaries(Arrays.asList(subjectAlternativeNameSummaries));
            return this;
        }

        public final Boolean getHasAdditionalSubjectAlternativeNames() {
            return this.hasAdditionalSubjectAlternativeNames;
        }

        public final void setHasAdditionalSubjectAlternativeNames(Boolean hasAdditionalSubjectAlternativeNames) {
            this.hasAdditionalSubjectAlternativeNames = hasAdditionalSubjectAlternativeNames;
        }

        @Override
        public final Builder hasAdditionalSubjectAlternativeNames(Boolean hasAdditionalSubjectAlternativeNames) {
            this.hasAdditionalSubjectAlternativeNames = hasAdditionalSubjectAlternativeNames;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm == null ? null : keyAlgorithm.toString());
            return this;
        }

        public final Collection<String> getKeyUsages() {
            if (this.keyUsages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keyUsages;
        }

        public final void setKeyUsages(Collection<String> keyUsages) {
            this.keyUsages = KeyUsageNamesCopier.copy(keyUsages);
        }

        @Override
        public final Builder keyUsagesWithStrings(Collection<String> keyUsages) {
            this.keyUsages = KeyUsageNamesCopier.copy(keyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsagesWithStrings(String ... keyUsages) {
            this.keyUsagesWithStrings(Arrays.asList(keyUsages));
            return this;
        }

        @Override
        public final Builder keyUsages(Collection<KeyUsageName> keyUsages) {
            this.keyUsages = KeyUsageNamesCopier.copyEnumToString(keyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsages(KeyUsageName ... keyUsages) {
            this.keyUsages(Arrays.asList(keyUsages));
            return this;
        }

        public final Collection<String> getExtendedKeyUsages() {
            if (this.extendedKeyUsages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.extendedKeyUsages;
        }

        public final void setExtendedKeyUsages(Collection<String> extendedKeyUsages) {
            this.extendedKeyUsages = ExtendedKeyUsageNamesCopier.copy(extendedKeyUsages);
        }

        @Override
        public final Builder extendedKeyUsagesWithStrings(Collection<String> extendedKeyUsages) {
            this.extendedKeyUsages = ExtendedKeyUsageNamesCopier.copy(extendedKeyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsagesWithStrings(String ... extendedKeyUsages) {
            this.extendedKeyUsagesWithStrings(Arrays.asList(extendedKeyUsages));
            return this;
        }

        @Override
        public final Builder extendedKeyUsages(Collection<ExtendedKeyUsageName> extendedKeyUsages) {
            this.extendedKeyUsages = ExtendedKeyUsageNamesCopier.copyEnumToString(extendedKeyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsages(ExtendedKeyUsageName ... extendedKeyUsages) {
            this.extendedKeyUsages(Arrays.asList(extendedKeyUsages));
            return this;
        }

        public final Boolean getInUse() {
            return this.inUse;
        }

        public final void setInUse(Boolean inUse) {
            this.inUse = inUse;
        }

        @Override
        public final Builder inUse(Boolean inUse) {
            this.inUse = inUse;
            return this;
        }

        public final Boolean getExported() {
            return this.exported;
        }

        public final void setExported(Boolean exported) {
            this.exported = exported;
        }

        @Override
        public final Builder exported(Boolean exported) {
            this.exported = exported;
            return this;
        }

        public final String getRenewalEligibility() {
            return this.renewalEligibility;
        }

        public final void setRenewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
        }

        @Override
        public final Builder renewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
            return this;
        }

        @Override
        public final Builder renewalEligibility(RenewalEligibility renewalEligibility) {
            this.renewalEligibility(renewalEligibility == null ? null : renewalEligibility.toString());
            return this;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final Instant getImportedAt() {
            return this.importedAt;
        }

        public final void setImportedAt(Instant importedAt) {
            this.importedAt = importedAt;
        }

        @Override
        public final Builder importedAt(Instant importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(CertificateManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        public CertificateSummary build() {
            return new CertificateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateSummary> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);

        public Builder subjectAlternativeNameSummaries(Collection<String> var1);

        public Builder subjectAlternativeNameSummaries(String ... var1);

        public Builder hasAdditionalSubjectAlternativeNames(Boolean var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder keyUsagesWithStrings(Collection<String> var1);

        public Builder keyUsagesWithStrings(String ... var1);

        public Builder keyUsages(Collection<KeyUsageName> var1);

        public Builder keyUsages(KeyUsageName ... var1);

        public Builder extendedKeyUsagesWithStrings(Collection<String> var1);

        public Builder extendedKeyUsagesWithStrings(String ... var1);

        public Builder extendedKeyUsages(Collection<ExtendedKeyUsageName> var1);

        public Builder extendedKeyUsages(ExtendedKeyUsageName ... var1);

        public Builder inUse(Boolean var1);

        public Builder exported(Boolean var1);

        public Builder renewalEligibility(String var1);

        public Builder renewalEligibility(RenewalEligibility var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder issuedAt(Instant var1);

        public Builder importedAt(Instant var1);

        public Builder revokedAt(Instant var1);

        public Builder managedBy(String var1);

        public Builder managedBy(CertificateManagedBy var1);
    }
}

