/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccountConfigurationRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, PutAccountConfigurationRequest> {
    private static final SdkField<ExpiryEventsConfiguration> EXPIRY_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpiryEvents").getter(PutAccountConfigurationRequest.getter(PutAccountConfigurationRequest::expiryEvents)).setter(PutAccountConfigurationRequest.setter(Builder::expiryEvents)).constructor(ExpiryEventsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryEvents").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(PutAccountConfigurationRequest.getter(PutAccountConfigurationRequest::idempotencyToken)).setter(PutAccountConfigurationRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRY_EVENTS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExpiryEvents", EXPIRY_EVENTS_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        }
    });
    private final ExpiryEventsConfiguration expiryEvents;
    private final String idempotencyToken;

    private PutAccountConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.expiryEvents = builder.expiryEvents;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final ExpiryEventsConfiguration expiryEvents() {
        return this.expiryEvents;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountConfigurationRequest)) {
            return false;
        }
        PutAccountConfigurationRequest other = (PutAccountConfigurationRequest)((Object)obj);
        return Objects.equals(this.expiryEvents(), other.expiryEvents()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"PutAccountConfigurationRequest").add("ExpiryEvents", (Object)this.expiryEvents()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpiryEvents": {
                return Optional.ofNullable(clazz.cast(this.expiryEvents()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountConfigurationRequest, T> g) {
        return obj -> g.apply((PutAccountConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private ExpiryEventsConfiguration expiryEvents;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountConfigurationRequest model) {
            super(model);
            this.expiryEvents(model.expiryEvents);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final ExpiryEventsConfiguration.Builder getExpiryEvents() {
            return this.expiryEvents != null ? this.expiryEvents.toBuilder() : null;
        }

        public final void setExpiryEvents(ExpiryEventsConfiguration.BuilderImpl expiryEvents) {
            this.expiryEvents = expiryEvents != null ? expiryEvents.build() : null;
        }

        @Override
        public final Builder expiryEvents(ExpiryEventsConfiguration expiryEvents) {
            this.expiryEvents = expiryEvents;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountConfigurationRequest build() {
            return new PutAccountConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccountConfigurationRequest> {
        public Builder expiryEvents(ExpiryEventsConfiguration var1);

        default public Builder expiryEvents(Consumer<ExpiryEventsConfiguration.Builder> expiryEvents) {
            return this.expiryEvents((ExpiryEventsConfiguration)((ExpiryEventsConfiguration.Builder)ExpiryEventsConfiguration.builder().applyMutation(expiryEvents)).build());
        }

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

