/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportCertificateResponse
extends AcmResponse
implements ToCopyableBuilder<Builder, ExportCertificateResponse> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(ExportCertificateResponse.getter(ExportCertificateResponse::certificate)).setter(ExportCertificateResponse.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateChain").getter(ExportCertificateResponse.getter(ExportCertificateResponse::certificateChain)).setter(ExportCertificateResponse.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKey").getter(ExportCertificateResponse.getter(ExportCertificateResponse::privateKey)).setter(ExportCertificateResponse.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD, PRIVATE_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Certificate", CERTIFICATE_FIELD);
            this.put("CertificateChain", CERTIFICATE_CHAIN_FIELD);
            this.put("PrivateKey", PRIVATE_KEY_FIELD);
        }
    });
    private final String certificate;
    private final String certificateChain;
    private final String privateKey;

    private ExportCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final String certificateChain() {
        return this.certificateChain;
    }

    public final String privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportCertificateResponse)) {
            return false;
        }
        ExportCertificateResponse other = (ExportCertificateResponse)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.privateKey(), other.privateKey());
    }

    public final String toString() {
        return ToString.builder((String)"ExportCertificateResponse").add("Certificate", (Object)this.certificate()).add("CertificateChain", (Object)this.certificateChain()).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportCertificateResponse, T> g) {
        return obj -> g.apply((ExportCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmResponse.BuilderImpl
    implements Builder {
        private String certificate;
        private String certificateChain;
        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportCertificateResponse model) {
            super(model);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
            this.privateKey(model.privateKey);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public ExportCertificateResponse build() {
            return new ExportCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportCertificateResponse> {
        public Builder certificate(String var1);

        public Builder certificateChain(String var1);

        public Builder privateKey(String var1);
    }
}

