/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmAsyncClient;
import software.amazon.awssdk.services.acm.AcmAsyncClientBuilder;
import software.amazon.awssdk.services.acm.AcmServiceClientConfiguration;
import software.amazon.awssdk.services.acm.DefaultAcmAsyncClient;
import software.amazon.awssdk.services.acm.DefaultAcmBaseClientBuilder;
import software.amazon.awssdk.services.acm.endpoints.AcmEndpointProvider;

@SdkInternalApi
final class DefaultAcmAsyncClientBuilder
extends DefaultAcmBaseClientBuilder<AcmAsyncClientBuilder, AcmAsyncClient>
implements AcmAsyncClientBuilder {
    DefaultAcmAsyncClientBuilder() {
    }

    @Override
    public DefaultAcmAsyncClientBuilder endpointProvider(AcmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAcmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AcmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAcmAsyncClient client = new DefaultAcmAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AcmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AcmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

