/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmAsyncClient;
import software.amazon.awssdk.services.acm.AcmAsyncClientBuilder;
import software.amazon.awssdk.services.acm.AcmServiceClientConfiguration;
import software.amazon.awssdk.services.acm.DefaultAcmAsyncClient;
import software.amazon.awssdk.services.acm.DefaultAcmBaseClientBuilder;
import software.amazon.awssdk.services.acm.endpoints.AcmEndpointProvider;

@SdkInternalApi
final class DefaultAcmAsyncClientBuilder
extends DefaultAcmBaseClientBuilder<AcmAsyncClientBuilder, AcmAsyncClient>
implements AcmAsyncClientBuilder {
    DefaultAcmAsyncClientBuilder() {
    }

    @Override
    public DefaultAcmAsyncClientBuilder endpointProvider(AcmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAcmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AcmServiceClientConfiguration serviceClientConfiguration = AcmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAcmAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

