/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExtendedKeyUsageName {
    TLS_WEB_SERVER_AUTHENTICATION("TLS_WEB_SERVER_AUTHENTICATION"),
    TLS_WEB_CLIENT_AUTHENTICATION("TLS_WEB_CLIENT_AUTHENTICATION"),
    CODE_SIGNING("CODE_SIGNING"),
    EMAIL_PROTECTION("EMAIL_PROTECTION"),
    TIME_STAMPING("TIME_STAMPING"),
    OCSP_SIGNING("OCSP_SIGNING"),
    IPSEC_END_SYSTEM("IPSEC_END_SYSTEM"),
    IPSEC_TUNNEL("IPSEC_TUNNEL"),
    IPSEC_USER("IPSEC_USER"),
    ANY("ANY"),
    NONE("NONE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExtendedKeyUsageName> VALUE_MAP;
    private final String value;

    private ExtendedKeyUsageName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExtendedKeyUsageName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExtendedKeyUsageName> knownValues() {
        EnumSet<ExtendedKeyUsageName> knownValues = EnumSet.allOf(ExtendedKeyUsageName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExtendedKeyUsageName.class, ExtendedKeyUsageName::toString);
    }
}

