/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedKeyUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtendedKeyUsage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ExtendedKeyUsage.getter(ExtendedKeyUsage::nameAsString)).setter(ExtendedKeyUsage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> OID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OID").getter(ExtendedKeyUsage.getter(ExtendedKeyUsage::oid)).setter(ExtendedKeyUsage.setter(Builder::oid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String oid;

    private ExtendedKeyUsage(BuilderImpl builder) {
        this.name = builder.name;
        this.oid = builder.oid;
    }

    public final ExtendedKeyUsageName name() {
        return ExtendedKeyUsageName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final String oid() {
        return this.oid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oid());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedKeyUsage)) {
            return false;
        }
        ExtendedKeyUsage other = (ExtendedKeyUsage)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.oid(), other.oid());
    }

    public final String toString() {
        return ToString.builder((String)"ExtendedKeyUsage").add("Name", (Object)this.nameAsString()).add("OID", (Object)this.oid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "OID": {
                return Optional.ofNullable(clazz.cast(this.oid()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedKeyUsage, T> g) {
        return obj -> g.apply((ExtendedKeyUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String oid;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedKeyUsage model) {
            this.name(model.name);
            this.oid(model.oid);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ExtendedKeyUsageName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOid() {
            return this.oid;
        }

        @Override
        public final Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public final void setOid(String oid) {
            this.oid = oid;
        }

        public ExtendedKeyUsage build() {
            return new ExtendedKeyUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtendedKeyUsage> {
        public Builder name(String var1);

        public Builder name(ExtendedKeyUsageName var1);

        public Builder oid(String var1);
    }
}

