/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.DomainStatus;
import software.amazon.awssdk.services.acm.model.ResourceRecord;
import software.amazon.awssdk.services.acm.model.ValidationEmailListCopier;
import software.amazon.awssdk.services.acm.model.ValidationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainValidation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainValidation> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainValidation.getter(DomainValidation::domainName)).setter(DomainValidation.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> VALIDATION_EMAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationEmails").getter(DomainValidation.getter(DomainValidation::validationEmails)).setter(DomainValidation.setter(Builder::validationEmails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationEmails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VALIDATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationDomain").getter(DomainValidation.getter(DomainValidation::validationDomain)).setter(DomainValidation.setter(Builder::validationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationDomain").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(DomainValidation.getter(DomainValidation::validationStatusAsString)).setter(DomainValidation.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final SdkField<ResourceRecord> RESOURCE_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceRecord").getter(DomainValidation.getter(DomainValidation::resourceRecord)).setter(DomainValidation.setter(Builder::resourceRecord)).constructor(ResourceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecord").build()}).build();
    private static final SdkField<String> VALIDATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationMethod").getter(DomainValidation.getter(DomainValidation::validationMethodAsString)).setter(DomainValidation.setter(Builder::validationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, VALIDATION_EMAILS_FIELD, VALIDATION_DOMAIN_FIELD, VALIDATION_STATUS_FIELD, RESOURCE_RECORD_FIELD, VALIDATION_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final List<String> validationEmails;
    private final String validationDomain;
    private final String validationStatus;
    private final ResourceRecord resourceRecord;
    private final String validationMethod;

    private DomainValidation(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationEmails = builder.validationEmails;
        this.validationDomain = builder.validationDomain;
        this.validationStatus = builder.validationStatus;
        this.resourceRecord = builder.resourceRecord;
        this.validationMethod = builder.validationMethod;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasValidationEmails() {
        return this.validationEmails != null && !(this.validationEmails instanceof SdkAutoConstructList);
    }

    public final List<String> validationEmails() {
        return this.validationEmails;
    }

    public final String validationDomain() {
        return this.validationDomain;
    }

    public final DomainStatus validationStatus() {
        return DomainStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final ResourceRecord resourceRecord() {
        return this.resourceRecord;
    }

    public final ValidationMethod validationMethod() {
        return ValidationMethod.fromValue(this.validationMethod);
    }

    public final String validationMethodAsString() {
        return this.validationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationEmails() ? this.validationEmails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidation)) {
            return false;
        }
        DomainValidation other = (DomainValidation)obj;
        return Objects.equals(this.domainName(), other.domainName()) && this.hasValidationEmails() == other.hasValidationEmails() && Objects.equals(this.validationEmails(), other.validationEmails()) && Objects.equals(this.validationDomain(), other.validationDomain()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.resourceRecord(), other.resourceRecord()) && Objects.equals(this.validationMethodAsString(), other.validationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DomainValidation").add("DomainName", (Object)this.domainName()).add("ValidationEmails", this.hasValidationEmails() ? this.validationEmails() : null).add("ValidationDomain", (Object)this.validationDomain()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("ResourceRecord", (Object)this.resourceRecord()).add("ValidationMethod", (Object)this.validationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ValidationEmails": {
                return Optional.ofNullable(clazz.cast(this.validationEmails()));
            }
            case "ValidationDomain": {
                return Optional.ofNullable(clazz.cast(this.validationDomain()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "ResourceRecord": {
                return Optional.ofNullable(clazz.cast(this.resourceRecord()));
            }
            case "ValidationMethod": {
                return Optional.ofNullable(clazz.cast(this.validationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainValidation, T> g) {
        return obj -> g.apply((DomainValidation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<String> validationEmails = DefaultSdkAutoConstructList.getInstance();
        private String validationDomain;
        private String validationStatus;
        private ResourceRecord resourceRecord;
        private String validationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidation model) {
            this.domainName(model.domainName);
            this.validationEmails(model.validationEmails);
            this.validationDomain(model.validationDomain);
            this.validationStatus(model.validationStatus);
            this.resourceRecord(model.resourceRecord);
            this.validationMethod(model.validationMethod);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getValidationEmails() {
            if (this.validationEmails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validationEmails;
        }

        public final void setValidationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
        }

        @Override
        public final Builder validationEmails(Collection<String> validationEmails) {
            this.validationEmails = ValidationEmailListCopier.copy(validationEmails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationEmails(String ... validationEmails) {
            this.validationEmails(Arrays.asList(validationEmails));
            return this;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(DomainStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return this.resourceRecord != null ? this.resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final String getValidationMethod() {
            return this.validationMethod;
        }

        public final void setValidationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
        }

        @Override
        public final Builder validationMethod(String validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        @Override
        public final Builder validationMethod(ValidationMethod validationMethod) {
            this.validationMethod(validationMethod == null ? null : validationMethod.toString());
            return this;
        }

        public DomainValidation build() {
            return new DomainValidation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainValidation> {
        public Builder domainName(String var1);

        public Builder validationEmails(Collection<String> var1);

        public Builder validationEmails(String ... var1);

        public Builder validationDomain(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(DomainStatus var1);

        public Builder resourceRecord(ResourceRecord var1);

        default public Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return this.resourceRecord((ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().applyMutation(resourceRecord)).build());
        }

        public Builder validationMethod(String var1);

        public Builder validationMethod(ValidationMethod var1);
    }
}

