/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCertificateResponse
extends AcmResponse
implements ToCopyableBuilder<Builder, GetCertificateResponse> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(GetCertificateResponse.getter(GetCertificateResponse::certificate)).setter(GetCertificateResponse.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateChain").getter(GetCertificateResponse.getter(GetCertificateResponse::certificateChain)).setter(GetCertificateResponse.setter(Builder::certificateChain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD));
    private final String certificate;
    private final String certificateChain;

    private GetCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
    }

    public String certificate() {
        return this.certificate;
    }

    public String certificateChain() {
        return this.certificateChain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificateResponse)) {
            return false;
        }
        GetCertificateResponse other = (GetCertificateResponse)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateChain(), other.certificateChain());
    }

    public String toString() {
        return ToString.builder((String)"GetCertificateResponse").add("Certificate", (Object)this.certificate()).add("CertificateChain", (Object)this.certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificateResponse, T> g) {
        return obj -> g.apply((GetCertificateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmResponse.BuilderImpl
    implements Builder {
        private String certificate;
        private String certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificateResponse model) {
            super(model);
            this.certificate(model.certificate);
            this.certificateChain(model.certificateChain);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public GetCertificateResponse build() {
            return new GetCertificateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCertificateResponse> {
        public Builder certificate(String var1);

        public Builder certificateChain(String var1);
    }
}

