/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateStatusesCopier;
import software.amazon.awssdk.services.acm.model.Filters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, ListCertificatesRequest> {
    private static final SdkField<List<String>> CERTIFICATE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateStatuses").getter(ListCertificatesRequest.getter(ListCertificatesRequest::certificateStatusesAsStrings)).setter(ListCertificatesRequest.setter(Builder::certificateStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Filters> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Includes").getter(ListCertificatesRequest.getter(ListCertificatesRequest::includes)).setter(ListCertificatesRequest.setter(Builder::includes)).constructor(Filters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificatesRequest.getter(ListCertificatesRequest::nextToken)).setter(ListCertificatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListCertificatesRequest.getter(ListCertificatesRequest::maxItems)).setter(ListCertificatesRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_STATUSES_FIELD, INCLUDES_FIELD, NEXT_TOKEN_FIELD, MAX_ITEMS_FIELD));
    private final List<String> certificateStatuses;
    private final Filters includes;
    private final String nextToken;
    private final Integer maxItems;

    private ListCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateStatuses = builder.certificateStatuses;
        this.includes = builder.includes;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public List<CertificateStatus> certificateStatuses() {
        return CertificateStatusesCopier.copyStringToEnum(this.certificateStatuses);
    }

    public boolean hasCertificateStatuses() {
        return this.certificateStatuses != null && !(this.certificateStatuses instanceof SdkAutoConstructList);
    }

    public List<String> certificateStatusesAsStrings() {
        return this.certificateStatuses;
    }

    public Filters includes() {
        return this.includes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateStatuses() ? this.certificateStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)((Object)obj);
        return this.hasCertificateStatuses() == other.hasCertificateStatuses() && Objects.equals(this.certificateStatusesAsStrings(), other.certificateStatusesAsStrings()) && Objects.equals(this.includes(), other.includes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificatesRequest").add("CertificateStatuses", this.hasCertificateStatuses() ? this.certificateStatusesAsStrings() : null).add("Includes", (Object)this.includes()).add("NextToken", (Object)this.nextToken()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateStatuses": {
                return Optional.ofNullable(clazz.cast(this.certificateStatusesAsStrings()));
            }
            case "Includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesRequest, T> g) {
        return obj -> g.apply((ListCertificatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private List<String> certificateStatuses = DefaultSdkAutoConstructList.getInstance();
        private Filters includes;
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesRequest model) {
            super(model);
            this.certificateStatusesWithStrings(model.certificateStatuses);
            this.includes(model.includes);
            this.nextToken(model.nextToken);
            this.maxItems(model.maxItems);
        }

        public final Collection<String> getCertificateStatuses() {
            if (this.certificateStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateStatuses;
        }

        @Override
        public final Builder certificateStatusesWithStrings(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatusesWithStrings(String ... certificateStatuses) {
            this.certificateStatusesWithStrings(Arrays.asList(certificateStatuses));
            return this;
        }

        @Override
        public final Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copyEnumToString(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(CertificateStatus ... certificateStatuses) {
            this.certificateStatuses(Arrays.asList(certificateStatuses));
            return this;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
        }

        public final Filters.Builder getIncludes() {
            return this.includes != null ? this.includes.toBuilder() : null;
        }

        @Override
        public final Builder includes(Filters includes) {
            this.includes = includes;
            return this;
        }

        public final void setIncludes(Filters.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCertificatesRequest build() {
            return new ListCertificatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificatesRequest> {
        public Builder certificateStatusesWithStrings(Collection<String> var1);

        public Builder certificateStatusesWithStrings(String ... var1);

        public Builder certificateStatuses(Collection<CertificateStatus> var1);

        public Builder certificateStatuses(CertificateStatus ... var1);

        public Builder includes(Filters var1);

        default public Builder includes(Consumer<Filters.Builder> includes) {
            return this.includes((Filters)((Filters.Builder)Filters.builder().applyMutation(includes)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

