/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.AcmResponse;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.CertificateSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesResponse
extends AcmResponse
implements ToCopyableBuilder<Builder, ListCertificatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificatesResponse.getter(ListCertificatesResponse::nextToken)).setter(ListCertificatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CertificateSummary>> CERTIFICATE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateSummaryList").getter(ListCertificatesResponse.getter(ListCertificatesResponse::certificateSummaryList)).setter(ListCertificatesResponse.setter(Builder::certificateSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CERTIFICATE_SUMMARY_LIST_FIELD));
    private final String nextToken;
    private final List<CertificateSummary> certificateSummaryList;

    private ListCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificateSummaryList = builder.certificateSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasCertificateSummaryList() {
        return this.certificateSummaryList != null && !(this.certificateSummaryList instanceof SdkAutoConstructList);
    }

    public List<CertificateSummary> certificateSummaryList() {
        return this.certificateSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateSummaryList() ? this.certificateSummaryList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCertificateSummaryList() == other.hasCertificateSummaryList() && Objects.equals(this.certificateSummaryList(), other.certificateSummaryList());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificatesResponse").add("NextToken", (Object)this.nextToken()).add("CertificateSummaryList", this.hasCertificateSummaryList() ? this.certificateSummaryList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CertificateSummaryList": {
                return Optional.ofNullable(clazz.cast(this.certificateSummaryList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesResponse, T> g) {
        return obj -> g.apply((ListCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CertificateSummary> certificateSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.certificateSummaryList(model.certificateSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CertificateSummary.Builder> getCertificateSummaryList() {
            if (this.certificateSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.certificateSummaryList != null ? (Collection)this.certificateSummaryList.stream().map(CertificateSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificateSummaryList(Collection<CertificateSummary> certificateSummaryList) {
            this.certificateSummaryList = CertificateSummaryListCopier.copy(certificateSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateSummaryList(CertificateSummary ... certificateSummaryList) {
            this.certificateSummaryList(Arrays.asList(certificateSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateSummaryList(Consumer<CertificateSummary.Builder> ... certificateSummaryList) {
            this.certificateSummaryList(Stream.of(certificateSummaryList).map(c -> (CertificateSummary)((CertificateSummary.Builder)CertificateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCertificateSummaryList(Collection<CertificateSummary.BuilderImpl> certificateSummaryList) {
            this.certificateSummaryList = CertificateSummaryListCopier.copyFromBuilder(certificateSummaryList);
        }

        @Override
        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificatesResponse> {
        public Builder nextToken(String var1);

        public Builder certificateSummaryList(Collection<CertificateSummary> var1);

        public Builder certificateSummaryList(CertificateSummary ... var1);

        public Builder certificateSummaryList(Consumer<CertificateSummary.Builder> ... var1);
    }
}

