/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.CertificateOptions;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateType;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsage;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageListCopier;
import software.amazon.awssdk.services.acm.model.FailureReason;
import software.amazon.awssdk.services.acm.model.InUseListCopier;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.KeyUsage;
import software.amazon.awssdk.services.acm.model.KeyUsageListCopier;
import software.amazon.awssdk.services.acm.model.RenewalEligibility;
import software.amazon.awssdk.services.acm.model.RenewalSummary;
import software.amazon.awssdk.services.acm.model.RevocationReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateDetail> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::certificateArn)).setter(CertificateDetail.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::domainName)).setter(CertificateDetail.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CertificateDetail.getter(CertificateDetail::subjectAlternativeNames)).setter(CertificateDetail.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DomainValidation>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CertificateDetail.getter(CertificateDetail::domainValidationOptions)).setter(CertificateDetail.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::serial)).setter(CertificateDetail.setter(Builder::serial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::subject)).setter(CertificateDetail.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::issuer)).setter(CertificateDetail.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::createdAt)).setter(CertificateDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::issuedAt)).setter(CertificateDetail.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()}).build();
    private static final SdkField<Instant> IMPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::importedAt)).setter(CertificateDetail.setter(Builder::importedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::statusAsString)).setter(CertificateDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::revokedAt)).setter(CertificateDetail.setter(Builder::revokedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokedAt").build()}).build();
    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::revocationReasonAsString)).setter(CertificateDetail.setter(Builder::revocationReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationReason").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::notBefore)).setter(CertificateDetail.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CertificateDetail.getter(CertificateDetail::notAfter)).setter(CertificateDetail.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::keyAlgorithmAsString)).setter(CertificateDetail.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAlgorithm").build()}).build();
    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::signatureAlgorithm)).setter(CertificateDetail.setter(Builder::signatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignatureAlgorithm").build()}).build();
    private static final SdkField<List<String>> IN_USE_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CertificateDetail.getter(CertificateDetail::inUseBy)).setter(CertificateDetail.setter(Builder::inUseBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::failureReasonAsString)).setter(CertificateDetail.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::typeAsString)).setter(CertificateDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<RenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CertificateDetail.getter(CertificateDetail::renewalSummary)).setter(CertificateDetail.setter(Builder::renewalSummary)).constructor(RenewalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalSummary").build()}).build();
    private static final SdkField<List<KeyUsage>> KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CertificateDetail.getter(CertificateDetail::keyUsages)).setter(CertificateDetail.setter(Builder::keyUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExtendedKeyUsage>> EXTENDED_KEY_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CertificateDetail.getter(CertificateDetail::extendedKeyUsages)).setter(CertificateDetail.setter(Builder::extendedKeyUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedKeyUsages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtendedKeyUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::certificateAuthorityArn)).setter(CertificateDetail.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<String> RENEWAL_ELIGIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CertificateDetail.getter(CertificateDetail::renewalEligibilityAsString)).setter(CertificateDetail.setter(Builder::renewalEligibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalEligibility").build()}).build();
    private static final SdkField<CertificateOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CertificateDetail.getter(CertificateDetail::options)).setter(CertificateDetail.setter(Builder::options)).constructor(CertificateOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, DOMAIN_NAME_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD, DOMAIN_VALIDATION_OPTIONS_FIELD, SERIAL_FIELD, SUBJECT_FIELD, ISSUER_FIELD, CREATED_AT_FIELD, ISSUED_AT_FIELD, IMPORTED_AT_FIELD, STATUS_FIELD, REVOKED_AT_FIELD, REVOCATION_REASON_FIELD, NOT_BEFORE_FIELD, NOT_AFTER_FIELD, KEY_ALGORITHM_FIELD, SIGNATURE_ALGORITHM_FIELD, IN_USE_BY_FIELD, FAILURE_REASON_FIELD, TYPE_FIELD, RENEWAL_SUMMARY_FIELD, KEY_USAGES_FIELD, EXTENDED_KEY_USAGES_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, RENEWAL_ELIGIBILITY_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String domainName;
    private final List<String> subjectAlternativeNames;
    private final List<DomainValidation> domainValidationOptions;
    private final String serial;
    private final String subject;
    private final String issuer;
    private final Instant createdAt;
    private final Instant issuedAt;
    private final Instant importedAt;
    private final String status;
    private final Instant revokedAt;
    private final String revocationReason;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String keyAlgorithm;
    private final String signatureAlgorithm;
    private final List<String> inUseBy;
    private final String failureReason;
    private final String type;
    private final RenewalSummary renewalSummary;
    private final List<KeyUsage> keyUsages;
    private final List<ExtendedKeyUsage> extendedKeyUsages;
    private final String certificateAuthorityArn;
    private final String renewalEligibility;
    private final CertificateOptions options;

    private CertificateDetail(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.serial = builder.serial;
        this.subject = builder.subject;
        this.issuer = builder.issuer;
        this.createdAt = builder.createdAt;
        this.issuedAt = builder.issuedAt;
        this.importedAt = builder.importedAt;
        this.status = builder.status;
        this.revokedAt = builder.revokedAt;
        this.revocationReason = builder.revocationReason;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.inUseBy = builder.inUseBy;
        this.failureReason = builder.failureReason;
        this.type = builder.type;
        this.renewalSummary = builder.renewalSummary;
        this.keyUsages = builder.keyUsages;
        this.extendedKeyUsages = builder.extendedKeyUsages;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.renewalEligibility = builder.renewalEligibility;
        this.options = builder.options;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public String serial() {
        return this.serial;
    }

    public String subject() {
        return this.subject;
    }

    public String issuer() {
        return this.issuer;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public Instant importedAt() {
        return this.importedAt;
    }

    public CertificateStatus status() {
        return CertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant revokedAt() {
        return this.revokedAt;
    }

    public RevocationReason revocationReason() {
        return RevocationReason.fromValue(this.revocationReason);
    }

    public String revocationReasonAsString() {
        return this.revocationReason;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public KeyAlgorithm keyAlgorithm() {
        return KeyAlgorithm.fromValue(this.keyAlgorithm);
    }

    public String keyAlgorithmAsString() {
        return this.keyAlgorithm;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public List<String> inUseBy() {
        return this.inUseBy;
    }

    public FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public String failureReasonAsString() {
        return this.failureReason;
    }

    public CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public RenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public List<KeyUsage> keyUsages() {
        return this.keyUsages;
    }

    public List<ExtendedKeyUsage> extendedKeyUsages() {
        return this.extendedKeyUsages;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public RenewalEligibility renewalEligibility() {
        return RenewalEligibility.fromValue(this.renewalEligibility);
    }

    public String renewalEligibilityAsString() {
        return this.renewalEligibility;
    }

    public CertificateOptions options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectAlternativeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainValidationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsages());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedKeyUsages());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalEligibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDetail)) {
            return false;
        }
        CertificateDetail other = (CertificateDetail)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames()) && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.importedAt(), other.importedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.revokedAt(), other.revokedAt()) && Objects.equals(this.revocationReasonAsString(), other.revocationReasonAsString()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.keyAlgorithmAsString(), other.keyAlgorithmAsString()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(this.inUseBy(), other.inUseBy()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.renewalSummary(), other.renewalSummary()) && Objects.equals(this.keyUsages(), other.keyUsages()) && Objects.equals(this.extendedKeyUsages(), other.extendedKeyUsages()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.renewalEligibilityAsString(), other.renewalEligibilityAsString()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"CertificateDetail").add("CertificateArn", (Object)this.certificateArn()).add("DomainName", (Object)this.domainName()).add("SubjectAlternativeNames", this.subjectAlternativeNames()).add("DomainValidationOptions", this.domainValidationOptions()).add("Serial", (Object)this.serial()).add("Subject", (Object)this.subject()).add("Issuer", (Object)this.issuer()).add("CreatedAt", (Object)this.createdAt()).add("IssuedAt", (Object)this.issuedAt()).add("ImportedAt", (Object)this.importedAt()).add("Status", (Object)this.statusAsString()).add("RevokedAt", (Object)this.revokedAt()).add("RevocationReason", (Object)this.revocationReasonAsString()).add("NotBefore", (Object)this.notBefore()).add("NotAfter", (Object)this.notAfter()).add("KeyAlgorithm", (Object)this.keyAlgorithmAsString()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).add("InUseBy", this.inUseBy()).add("FailureReason", (Object)this.failureReasonAsString()).add("Type", (Object)this.typeAsString()).add("RenewalSummary", (Object)this.renewalSummary()).add("KeyUsages", this.keyUsages()).add("ExtendedKeyUsages", this.extendedKeyUsages()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("RenewalEligibility", (Object)this.renewalEligibilityAsString()).add("Options", (Object)this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SubjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
            case "Serial": {
                return Optional.ofNullable(clazz.cast(this.serial()));
            }
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "ImportedAt": {
                return Optional.ofNullable(clazz.cast(this.importedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RevokedAt": {
                return Optional.ofNullable(clazz.cast(this.revokedAt()));
            }
            case "RevocationReason": {
                return Optional.ofNullable(clazz.cast(this.revocationReasonAsString()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "KeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithmAsString()));
            }
            case "SignatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
            case "InUseBy": {
                return Optional.ofNullable(clazz.cast(this.inUseBy()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "RenewalSummary": {
                return Optional.ofNullable(clazz.cast(this.renewalSummary()));
            }
            case "KeyUsages": {
                return Optional.ofNullable(clazz.cast(this.keyUsages()));
            }
            case "ExtendedKeyUsages": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsages()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "RenewalEligibility": {
                return Optional.ofNullable(clazz.cast(this.renewalEligibilityAsString()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateDetail, T> g) {
        return obj -> g.apply((CertificateDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();
        private List<DomainValidation> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();
        private String serial;
        private String subject;
        private String issuer;
        private Instant createdAt;
        private Instant issuedAt;
        private Instant importedAt;
        private String status;
        private Instant revokedAt;
        private String revocationReason;
        private Instant notBefore;
        private Instant notAfter;
        private String keyAlgorithm;
        private String signatureAlgorithm;
        private List<String> inUseBy = DefaultSdkAutoConstructList.getInstance();
        private String failureReason;
        private String type;
        private RenewalSummary renewalSummary;
        private List<KeyUsage> keyUsages = DefaultSdkAutoConstructList.getInstance();
        private List<ExtendedKeyUsage> extendedKeyUsages = DefaultSdkAutoConstructList.getInstance();
        private String certificateAuthorityArn;
        private String renewalEligibility;
        private CertificateOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDetail model) {
            this.certificateArn(model.certificateArn);
            this.domainName(model.domainName);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
            this.domainValidationOptions(model.domainValidationOptions);
            this.serial(model.serial);
            this.subject(model.subject);
            this.issuer(model.issuer);
            this.createdAt(model.createdAt);
            this.issuedAt(model.issuedAt);
            this.importedAt(model.importedAt);
            this.status(model.status);
            this.revokedAt(model.revokedAt);
            this.revocationReason(model.revocationReason);
            this.notBefore(model.notBefore);
            this.notAfter(model.notAfter);
            this.keyAlgorithm(model.keyAlgorithm);
            this.signatureAlgorithm(model.signatureAlgorithm);
            this.inUseBy(model.inUseBy);
            this.failureReason(model.failureReason);
            this.type(model.type);
            this.renewalSummary(model.renewalSummary);
            this.keyUsages(model.keyUsages);
            this.extendedKeyUsages(model.extendedKeyUsages);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.renewalEligibility(model.renewalEligibility);
            this.options(model.options);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        public final Collection<DomainValidation.Builder> getDomainValidationOptions() {
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(DomainValidation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (DomainValidation)((DomainValidation.Builder)DomainValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copyFromBuilder(domainValidationOptions);
        }

        public final String getSerial() {
            return this.serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final Instant getImportedAt() {
            return this.importedAt;
        }

        @Override
        public final Builder importedAt(Instant importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final void setImportedAt(Instant importedAt) {
            this.importedAt = importedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason.toString());
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm.toString());
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final Collection<String> getInUseBy() {
            return this.inUseBy;
        }

        @Override
        public final Builder inUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inUseBy(String ... inUseBy) {
            this.inUseBy(Arrays.asList(inUseBy));
            return this;
        }

        public final void setInUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final RenewalSummary.Builder getRenewalSummary() {
            return this.renewalSummary != null ? this.renewalSummary.toBuilder() : null;
        }

        @Override
        public final Builder renewalSummary(RenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(RenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        public final Collection<KeyUsage.Builder> getKeyUsages() {
            return this.keyUsages != null ? (Collection)this.keyUsages.stream().map(KeyUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyUsages(Collection<KeyUsage> keyUsages) {
            this.keyUsages = KeyUsageListCopier.copy(keyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsages(KeyUsage ... keyUsages) {
            this.keyUsages(Arrays.asList(keyUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsages(Consumer<KeyUsage.Builder> ... keyUsages) {
            this.keyUsages(Stream.of(keyUsages).map(c -> (KeyUsage)((KeyUsage.Builder)KeyUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyUsages(Collection<KeyUsage.BuilderImpl> keyUsages) {
            this.keyUsages = KeyUsageListCopier.copyFromBuilder(keyUsages);
        }

        public final Collection<ExtendedKeyUsage.Builder> getExtendedKeyUsages() {
            return this.extendedKeyUsages != null ? (Collection)this.extendedKeyUsages.stream().map(ExtendedKeyUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extendedKeyUsages(Collection<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = ExtendedKeyUsageListCopier.copy(extendedKeyUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsages(ExtendedKeyUsage ... extendedKeyUsages) {
            this.extendedKeyUsages(Arrays.asList(extendedKeyUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsages(Consumer<ExtendedKeyUsage.Builder> ... extendedKeyUsages) {
            this.extendedKeyUsages(Stream.of(extendedKeyUsages).map(c -> (ExtendedKeyUsage)((ExtendedKeyUsage.Builder)ExtendedKeyUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExtendedKeyUsages(Collection<ExtendedKeyUsage.BuilderImpl> extendedKeyUsages) {
            this.extendedKeyUsages = ExtendedKeyUsageListCopier.copyFromBuilder(extendedKeyUsages);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final String getRenewalEligibility() {
            return this.renewalEligibility;
        }

        @Override
        public final Builder renewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
            return this;
        }

        @Override
        public final Builder renewalEligibility(RenewalEligibility renewalEligibility) {
            this.renewalEligibility(renewalEligibility.toString());
            return this;
        }

        public final void setRenewalEligibility(String renewalEligibility) {
            this.renewalEligibility = renewalEligibility;
        }

        public final CertificateOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(CertificateOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(CertificateOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public CertificateDetail build() {
            return new CertificateDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateDetail> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);

        public Builder domainValidationOptions(Consumer<DomainValidation.Builder> ... var1);

        public Builder serial(String var1);

        public Builder subject(String var1);

        public Builder issuer(String var1);

        public Builder createdAt(Instant var1);

        public Builder issuedAt(Instant var1);

        public Builder importedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder revokedAt(Instant var1);

        public Builder revocationReason(String var1);

        public Builder revocationReason(RevocationReason var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder signatureAlgorithm(String var1);

        public Builder inUseBy(Collection<String> var1);

        public Builder inUseBy(String ... var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder renewalSummary(RenewalSummary var1);

        default public Builder renewalSummary(Consumer<RenewalSummary.Builder> renewalSummary) {
            return this.renewalSummary((RenewalSummary)((RenewalSummary.Builder)RenewalSummary.builder().applyMutation(renewalSummary)).build());
        }

        public Builder keyUsages(Collection<KeyUsage> var1);

        public Builder keyUsages(KeyUsage ... var1);

        public Builder keyUsages(Consumer<KeyUsage.Builder> ... var1);

        public Builder extendedKeyUsages(Collection<ExtendedKeyUsage> var1);

        public Builder extendedKeyUsages(ExtendedKeyUsage ... var1);

        public Builder extendedKeyUsages(Consumer<ExtendedKeyUsage.Builder> ... var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder renewalEligibility(String var1);

        public Builder renewalEligibility(RenewalEligibility var1);

        public Builder options(CertificateOptions var1);

        default public Builder options(Consumer<CertificateOptions.Builder> options) {
            return this.options((CertificateOptions)((CertificateOptions.Builder)CertificateOptions.builder().applyMutation(options)).build());
        }
    }
}

