/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.acm.ACMClient;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;

public class ListCertificatesIterable
implements SdkIterable<ListCertificatesResponse> {
    private final ACMClient client;
    private final ListCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCertificatesIterable(ACMClient client, ListCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCertificatesResponseFetcher();
    }

    public Iterator<ListCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CertificateSummary> certificateSummaryList() {
        Function<ListCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificateSummaryList() != null) {
                return response.certificateSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListCertificatesIterable resume(ListCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCertificatesIterable(this.client, (ListCertificatesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCertificatesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCertificatesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCertificatesResponseFetcher
    implements SyncPageFetcher<ListCertificatesResponse> {
        private ListCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCertificatesResponse nextPage(ListCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesIterable.this.client.listCertificates(ListCertificatesIterable.this.firstRequest);
            }
            return ListCertificatesIterable.this.client.listCertificates((ListCertificatesRequest)((Object)ListCertificatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

