/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.CertificateDetail;

@SdkInternalApi
public class CertificateDetailMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<List> SUBJECTALTERNATIVENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubjectAlternativeNames").build();
    private static final MarshallingInfo<List> DOMAINVALIDATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainValidationOptions").build();
    private static final MarshallingInfo<String> SERIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Serial").build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").build();
    private static final MarshallingInfo<String> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").build();
    private static final MarshallingInfo<Instant> ISSUEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IssuedAt").build();
    private static final MarshallingInfo<Instant> IMPORTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedAt").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Instant> REVOKEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevokedAt").build();
    private static final MarshallingInfo<String> REVOCATIONREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RevocationReason").build();
    private static final MarshallingInfo<Instant> NOTBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotBefore").build();
    private static final MarshallingInfo<Instant> NOTAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotAfter").build();
    private static final MarshallingInfo<String> KEYALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAlgorithm").build();
    private static final MarshallingInfo<String> SIGNATUREALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignatureAlgorithm").build();
    private static final MarshallingInfo<List> INUSEBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InUseBy").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<StructuredPojo> RENEWALSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RenewalSummary").build();
    private static final CertificateDetailMarshaller INSTANCE = new CertificateDetailMarshaller();

    public static CertificateDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CertificateDetail certificateDetail, ProtocolMarshaller protocolMarshaller) {
        if (certificateDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)certificateDetail.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(certificateDetail.subjectAlternativeNames(), SUBJECTALTERNATIVENAMES_BINDING);
            protocolMarshaller.marshall(certificateDetail.domainValidationOptions(), DOMAINVALIDATIONOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.serial(), SERIAL_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.issuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.issuedAt(), ISSUEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.importedAt(), IMPORTEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.revokedAt(), REVOKEDAT_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.revocationReasonString(), REVOCATIONREASON_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.notBefore(), NOTBEFORE_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.notAfter(), NOTAFTER_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.keyAlgorithmString(), KEYALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.signatureAlgorithm(), SIGNATUREALGORITHM_BINDING);
            protocolMarshaller.marshall(certificateDetail.inUseBy(), INUSEBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.failureReasonString(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)certificateDetail.renewalSummary(), RENEWALSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

