/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.RenewalStatus;
import software.amazon.awssdk.services.acm.transform.RenewalSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RenewalSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, RenewalSummary> {
    private final String renewalStatus;
    private final List<DomainValidation> domainValidationOptions;

    private RenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    public RenewalStatus renewalStatus() {
        return RenewalStatus.fromValue(this.renewalStatus);
    }

    public String renewalStatusString() {
        return this.renewalStatus;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainValidationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary)obj;
        return Objects.equals(this.renewalStatusString(), other.renewalStatusString()) && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions());
    }

    public String toString() {
        return ToString.builder((String)"RenewalSummary").add("RenewalStatus", (Object)this.renewalStatusString()).add("DomainValidationOptions", this.domainValidationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenewalStatus": {
                return Optional.of(clazz.cast(this.renewalStatusString()));
            }
            case "DomainValidationOptions": {
                return Optional.of(clazz.cast(this.domainValidationOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RenewalSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String renewalStatus;
        private List<DomainValidation> domainValidationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            this.renewalStatus(model.renewalStatus);
            this.domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final Collection<DomainValidation.Builder> getDomainValidationOptions() {
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(DomainValidation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copyFromBuilder(domainValidationOptions);
        }

        public RenewalSummary build() {
            return new RenewalSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RenewalSummary> {
        public Builder renewalStatus(String var1);

        public Builder renewalStatus(RenewalStatus var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);
    }
}

