/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.acm.ACMClient;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;

public final class ListCertificatesPaginator
implements SdkIterable<ListCertificatesResponse> {
    private final ACMClient client;
    private final ListCertificatesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCertificatesPaginator(ACMClient client, ListCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCertificatesResponseFetcher();
    }

    public Iterator<ListCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CertificateSummary> certificateSummaryList() {
        Function<ListCertificatesResponse, Iterator> getIterator = response -> response != null ? response.certificateSummaryList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListCertificatesResponseFetcher
    implements NextPageFetcher<ListCertificatesResponse> {
        private ListCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCertificatesResponse nextPage(ListCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesPaginator.this.client.listCertificates(ListCertificatesPaginator.this.firstRequest);
            }
            return ListCertificatesPaginator.this.client.listCertificates((ListCertificatesRequest)((Object)ListCertificatesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

