/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResendValidationEmailRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResendValidationEmailRequest> {
    private final String certificateArn;
    private final String domain;
    private final String validationDomain;

    private ResendValidationEmailRequest(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domain = builder.domain;
        this.validationDomain = builder.validationDomain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domain() {
        return this.domain;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        hashCode = 31 * hashCode + (this.validationDomain() == null ? 0 : this.validationDomain().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendValidationEmailRequest)) {
            return false;
        }
        ResendValidationEmailRequest other = (ResendValidationEmailRequest)((Object)obj);
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.validationDomain() == null ^ this.validationDomain() == null) {
            return false;
        }
        return other.validationDomain() == null || other.validationDomain().equals(this.validationDomain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.validationDomain() != null) {
            sb.append("ValidationDomain: ").append(this.validationDomain()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
            case "Domain": {
                return Optional.of(clazz.cast(this.domain()));
            }
            case "ValidationDomain": {
                return Optional.of(clazz.cast(this.validationDomain()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domain;
        private String validationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendValidationEmailRequest model) {
            this.certificateArn(model.certificateArn);
            this.domain(model.domain);
            this.validationDomain(model.validationDomain);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        public ResendValidationEmailRequest build() {
            return new ResendValidationEmailRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResendValidationEmailRequest> {
        public Builder certificateArn(String var1);

        public Builder domain(String var1);

        public Builder validationDomain(String var1);
    }
}

