/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.RenewalSummary;

@SdkInternalApi
public class RenewalSummaryMarshaller {
    private static final MarshallingInfo<String> RENEWALSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RenewalStatus").build();
    private static final MarshallingInfo<List> DOMAINVALIDATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainValidationOptions").build();
    private static final RenewalSummaryMarshaller INSTANCE = new RenewalSummaryMarshaller();

    public static RenewalSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RenewalSummary renewalSummary, ProtocolMarshaller protocolMarshaller) {
        if (renewalSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)renewalSummary.renewalStatus(), RENEWALSTATUS_BINDING);
            protocolMarshaller.marshall(renewalSummary.domainValidationOptions(), DOMAINVALIDATIONOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

