/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.ImportCertificateRequest;

@SdkInternalApi
public class ImportCertificateRequestModelMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").build();
    private static final MarshallingInfo<ByteBuffer> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").build();
    private static final MarshallingInfo<ByteBuffer> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final MarshallingInfo<ByteBuffer> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateChain").build();
    private static final ImportCertificateRequestModelMarshaller INSTANCE = new ImportCertificateRequestModelMarshaller();

    public static ImportCertificateRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ImportCertificateRequest importCertificateRequest, ProtocolMarshaller protocolMarshaller) {
        if (importCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)importCertificateRequest.certificateChain(), CERTIFICATECHAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

