/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.transform.CertificateSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CertificateSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, CertificateSummary> {
    private final String certificateArn;
    private final String domainName;

    private CertificateSummary(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSummary)) {
            return false;
        }
        CertificateSummary other = (CertificateSummary)obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        return other.domainName() == null || other.domainName().equals(this.domainName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSummary model) {
            this.setCertificateArn(model.certificateArn);
            this.setDomainName(model.domainName);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public CertificateSummary build() {
            return new CertificateSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CertificateSummary> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);
    }
}

