/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateType;
import software.amazon.awssdk.services.acm.model.DomainListCopier;
import software.amazon.awssdk.services.acm.model.DomainValidation;
import software.amazon.awssdk.services.acm.model.DomainValidationListCopier;
import software.amazon.awssdk.services.acm.model.FailureReason;
import software.amazon.awssdk.services.acm.model.InUseListCopier;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.RenewalSummary;
import software.amazon.awssdk.services.acm.model.RevocationReason;
import software.amazon.awssdk.services.acm.transform.CertificateDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CertificateDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, CertificateDetail> {
    private final String certificateArn;
    private final String domainName;
    private final List<String> subjectAlternativeNames;
    private final List<DomainValidation> domainValidationOptions;
    private final String serial;
    private final String subject;
    private final String issuer;
    private final Instant createdAt;
    private final Instant issuedAt;
    private final Instant importedAt;
    private final String status;
    private final Instant revokedAt;
    private final String revocationReason;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String keyAlgorithm;
    private final String signatureAlgorithm;
    private final List<String> inUseBy;
    private final String failureReason;
    private final String type;
    private final RenewalSummary renewalSummary;

    private CertificateDetail(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.domainName = builder.domainName;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
        this.domainValidationOptions = builder.domainValidationOptions;
        this.serial = builder.serial;
        this.subject = builder.subject;
        this.issuer = builder.issuer;
        this.createdAt = builder.createdAt;
        this.issuedAt = builder.issuedAt;
        this.importedAt = builder.importedAt;
        this.status = builder.status;
        this.revokedAt = builder.revokedAt;
        this.revocationReason = builder.revocationReason;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.inUseBy = builder.inUseBy;
        this.failureReason = builder.failureReason;
        this.type = builder.type;
        this.renewalSummary = builder.renewalSummary;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public List<DomainValidation> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public String serial() {
        return this.serial;
    }

    public String subject() {
        return this.subject;
    }

    public String issuer() {
        return this.issuer;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Instant issuedAt() {
        return this.issuedAt;
    }

    public Instant importedAt() {
        return this.importedAt;
    }

    public String status() {
        return this.status;
    }

    public Instant revokedAt() {
        return this.revokedAt;
    }

    public String revocationReason() {
        return this.revocationReason;
    }

    public Instant notBefore() {
        return this.notBefore;
    }

    public Instant notAfter() {
        return this.notAfter;
    }

    public String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public List<String> inUseBy() {
        return this.inUseBy;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String type() {
        return this.type;
    }

    public RenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.subjectAlternativeNames() == null ? 0 : this.subjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.domainValidationOptions() == null ? 0 : this.domainValidationOptions().hashCode());
        hashCode = 31 * hashCode + (this.serial() == null ? 0 : this.serial().hashCode());
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.issuer() == null ? 0 : this.issuer().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.issuedAt() == null ? 0 : this.issuedAt().hashCode());
        hashCode = 31 * hashCode + (this.importedAt() == null ? 0 : this.importedAt().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.revokedAt() == null ? 0 : this.revokedAt().hashCode());
        hashCode = 31 * hashCode + (this.revocationReason() == null ? 0 : this.revocationReason().hashCode());
        hashCode = 31 * hashCode + (this.notBefore() == null ? 0 : this.notBefore().hashCode());
        hashCode = 31 * hashCode + (this.notAfter() == null ? 0 : this.notAfter().hashCode());
        hashCode = 31 * hashCode + (this.keyAlgorithm() == null ? 0 : this.keyAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.signatureAlgorithm() == null ? 0 : this.signatureAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.inUseBy() == null ? 0 : this.inUseBy().hashCode());
        hashCode = 31 * hashCode + (this.failureReason() == null ? 0 : this.failureReason().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.renewalSummary() == null ? 0 : this.renewalSummary().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDetail)) {
            return false;
        }
        CertificateDetail other = (CertificateDetail)obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.subjectAlternativeNames() == null ^ this.subjectAlternativeNames() == null) {
            return false;
        }
        if (other.subjectAlternativeNames() != null && !other.subjectAlternativeNames().equals(this.subjectAlternativeNames())) {
            return false;
        }
        if (other.domainValidationOptions() == null ^ this.domainValidationOptions() == null) {
            return false;
        }
        if (other.domainValidationOptions() != null && !other.domainValidationOptions().equals(this.domainValidationOptions())) {
            return false;
        }
        if (other.serial() == null ^ this.serial() == null) {
            return false;
        }
        if (other.serial() != null && !other.serial().equals(this.serial())) {
            return false;
        }
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.issuer() == null ^ this.issuer() == null) {
            return false;
        }
        if (other.issuer() != null && !other.issuer().equals(this.issuer())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.issuedAt() == null ^ this.issuedAt() == null) {
            return false;
        }
        if (other.issuedAt() != null && !other.issuedAt().equals(this.issuedAt())) {
            return false;
        }
        if (other.importedAt() == null ^ this.importedAt() == null) {
            return false;
        }
        if (other.importedAt() != null && !other.importedAt().equals(this.importedAt())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.revokedAt() == null ^ this.revokedAt() == null) {
            return false;
        }
        if (other.revokedAt() != null && !other.revokedAt().equals(this.revokedAt())) {
            return false;
        }
        if (other.revocationReason() == null ^ this.revocationReason() == null) {
            return false;
        }
        if (other.revocationReason() != null && !other.revocationReason().equals(this.revocationReason())) {
            return false;
        }
        if (other.notBefore() == null ^ this.notBefore() == null) {
            return false;
        }
        if (other.notBefore() != null && !other.notBefore().equals(this.notBefore())) {
            return false;
        }
        if (other.notAfter() == null ^ this.notAfter() == null) {
            return false;
        }
        if (other.notAfter() != null && !other.notAfter().equals(this.notAfter())) {
            return false;
        }
        if (other.keyAlgorithm() == null ^ this.keyAlgorithm() == null) {
            return false;
        }
        if (other.keyAlgorithm() != null && !other.keyAlgorithm().equals(this.keyAlgorithm())) {
            return false;
        }
        if (other.signatureAlgorithm() == null ^ this.signatureAlgorithm() == null) {
            return false;
        }
        if (other.signatureAlgorithm() != null && !other.signatureAlgorithm().equals(this.signatureAlgorithm())) {
            return false;
        }
        if (other.inUseBy() == null ^ this.inUseBy() == null) {
            return false;
        }
        if (other.inUseBy() != null && !other.inUseBy().equals(this.inUseBy())) {
            return false;
        }
        if (other.failureReason() == null ^ this.failureReason() == null) {
            return false;
        }
        if (other.failureReason() != null && !other.failureReason().equals(this.failureReason())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.renewalSummary() == null ^ this.renewalSummary() == null) {
            return false;
        }
        return other.renewalSummary() == null || other.renewalSummary().equals(this.renewalSummary());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.subjectAlternativeNames() != null) {
            sb.append("SubjectAlternativeNames: ").append(this.subjectAlternativeNames()).append(",");
        }
        if (this.domainValidationOptions() != null) {
            sb.append("DomainValidationOptions: ").append(this.domainValidationOptions()).append(",");
        }
        if (this.serial() != null) {
            sb.append("Serial: ").append(this.serial()).append(",");
        }
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.issuer() != null) {
            sb.append("Issuer: ").append(this.issuer()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.issuedAt() != null) {
            sb.append("IssuedAt: ").append(this.issuedAt()).append(",");
        }
        if (this.importedAt() != null) {
            sb.append("ImportedAt: ").append(this.importedAt()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.revokedAt() != null) {
            sb.append("RevokedAt: ").append(this.revokedAt()).append(",");
        }
        if (this.revocationReason() != null) {
            sb.append("RevocationReason: ").append(this.revocationReason()).append(",");
        }
        if (this.notBefore() != null) {
            sb.append("NotBefore: ").append(this.notBefore()).append(",");
        }
        if (this.notAfter() != null) {
            sb.append("NotAfter: ").append(this.notAfter()).append(",");
        }
        if (this.keyAlgorithm() != null) {
            sb.append("KeyAlgorithm: ").append(this.keyAlgorithm()).append(",");
        }
        if (this.signatureAlgorithm() != null) {
            sb.append("SignatureAlgorithm: ").append(this.signatureAlgorithm()).append(",");
        }
        if (this.inUseBy() != null) {
            sb.append("InUseBy: ").append(this.inUseBy()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.renewalSummary() != null) {
            sb.append("RenewalSummary: ").append(this.renewalSummary()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificateDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String domainName;
        private List<String> subjectAlternativeNames;
        private List<DomainValidation> domainValidationOptions;
        private String serial;
        private String subject;
        private String issuer;
        private Instant createdAt;
        private Instant issuedAt;
        private Instant importedAt;
        private String status;
        private Instant revokedAt;
        private String revocationReason;
        private Instant notBefore;
        private Instant notAfter;
        private String keyAlgorithm;
        private String signatureAlgorithm;
        private List<String> inUseBy;
        private String failureReason;
        private String type;
        private RenewalSummary renewalSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDetail model) {
            this.setCertificateArn(model.certificateArn);
            this.setDomainName(model.domainName);
            this.setSubjectAlternativeNames(model.subjectAlternativeNames);
            this.setDomainValidationOptions(model.domainValidationOptions);
            this.setSerial(model.serial);
            this.setSubject(model.subject);
            this.setIssuer(model.issuer);
            this.setCreatedAt(model.createdAt);
            this.setIssuedAt(model.issuedAt);
            this.setImportedAt(model.importedAt);
            this.setStatus(model.status);
            this.setRevokedAt(model.revokedAt);
            this.setRevocationReason(model.revocationReason);
            this.setNotBefore(model.notBefore);
            this.setNotAfter(model.notAfter);
            this.setKeyAlgorithm(model.keyAlgorithm);
            this.setSignatureAlgorithm(model.signatureAlgorithm);
            this.setInUseBy(model.inUseBy);
            this.setFailureReason(model.failureReason);
            this.setType(model.type);
            this.setRenewalSummary(model.renewalSummary);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = DomainListCopier.copy(subjectAlternativeNames);
        }

        @SafeVarargs
        public final void setSubjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
        }

        public final Collection<DomainValidation> getDomainValidationOptions() {
            return this.domainValidationOptions;
        }

        @Override
        public final Builder domainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        public final void setDomainValidationOptions(Collection<DomainValidation> domainValidationOptions) {
            this.domainValidationOptions = DomainValidationListCopier.copy(domainValidationOptions);
        }

        @SafeVarargs
        public final void setDomainValidationOptions(DomainValidation ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
        }

        public final String getSerial() {
            return this.serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final Instant getImportedAt() {
            return this.importedAt;
        }

        @Override
        public final Builder importedAt(Instant importedAt) {
            this.importedAt = importedAt;
            return this;
        }

        public final void setImportedAt(Instant importedAt) {
            this.importedAt = importedAt;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(CertificateStatus status) {
            this.status(status.toString());
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason.toString());
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final void setRevocationReason(RevocationReason revocationReason) {
            this.revocationReason(revocationReason.toString());
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        @Override
        public final Builder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm.toString());
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final void setKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm(keyAlgorithm.toString());
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final Collection<String> getInUseBy() {
            return this.inUseBy;
        }

        @Override
        public final Builder inUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inUseBy(String ... inUseBy) {
            this.inUseBy(Arrays.asList(inUseBy));
            return this;
        }

        public final void setInUseBy(Collection<String> inUseBy) {
            this.inUseBy = InUseListCopier.copy(inUseBy);
        }

        @SafeVarargs
        public final void setInUseBy(String ... inUseBy) {
            this.inUseBy(Arrays.asList(inUseBy));
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final void setFailureReason(FailureReason failureReason) {
            this.failureReason(failureReason.toString());
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(CertificateType type) {
            this.type(type.toString());
        }

        public final RenewalSummary getRenewalSummary() {
            return this.renewalSummary;
        }

        @Override
        public final Builder renewalSummary(RenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(RenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
        }

        public CertificateDetail build() {
            return new CertificateDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CertificateDetail> {
        public Builder certificateArn(String var1);

        public Builder domainName(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);

        public Builder domainValidationOptions(Collection<DomainValidation> var1);

        public Builder domainValidationOptions(DomainValidation ... var1);

        public Builder serial(String var1);

        public Builder subject(String var1);

        public Builder issuer(String var1);

        public Builder createdAt(Instant var1);

        public Builder issuedAt(Instant var1);

        public Builder importedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(CertificateStatus var1);

        public Builder revokedAt(Instant var1);

        public Builder revocationReason(String var1);

        public Builder revocationReason(RevocationReason var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder keyAlgorithm(String var1);

        public Builder keyAlgorithm(KeyAlgorithm var1);

        public Builder signatureAlgorithm(String var1);

        public Builder inUseBy(Collection<String> var1);

        public Builder inUseBy(String ... var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);

        public Builder renewalSummary(RenewalSummary var1);
    }
}

