/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.DomainValidationOption;

@SdkInternalApi
public class DomainValidationOptionMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").build();
    private static final MarshallingInfo<String> VALIDATIONDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ValidationDomain").build();
    private static final DomainValidationOptionMarshaller instance = new DomainValidationOptionMarshaller();

    public static DomainValidationOptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DomainValidationOption domainValidationOption, ProtocolMarshaller protocolMarshaller) {
        if (domainValidationOption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)domainValidationOption.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainValidationOption.validationDomain(), VALIDATIONDOMAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

