/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.acm.model.KeyUsage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyUsageMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final KeyUsageMarshaller INSTANCE = new KeyUsageMarshaller();

    private KeyUsageMarshaller() {
    }

    public static KeyUsageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyUsage keyUsage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyUsage, (String)"keyUsage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyUsage.nameAsString(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

