/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.acm.AcmAsyncClient;
import software.amazon.awssdk.services.acm.model.CertificateSummary;
import software.amazon.awssdk.services.acm.model.ListCertificatesRequest;
import software.amazon.awssdk.services.acm.model.ListCertificatesResponse;

public class ListCertificatesPublisher
implements SdkPublisher<ListCertificatesResponse> {
    private final AcmAsyncClient client;
    private final ListCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCertificatesPublisher(AcmAsyncClient client, ListCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCertificatesPublisher(AcmAsyncClient client, ListCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CertificateSummary> certificateSummaryList() {
        Function<ListCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificateSummaryList() != null) {
                return response.certificateSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListCertificatesPublisher resume(ListCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCertificatesPublisher(this.client, (ListCertificatesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCertificatesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListCertificatesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListCertificatesResponseFetcher
    implements AsyncPageFetcher<ListCertificatesResponse> {
        private ListCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCertificatesResponse> nextPage(ListCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCertificatesPublisher.this.client.listCertificates(ListCertificatesPublisher.this.firstRequest);
            }
            return ListCertificatesPublisher.this.client.listCertificates((ListCertificatesRequest)((Object)ListCertificatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

