/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageFilterListCopier;
import software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName;
import software.amazon.awssdk.services.acm.model.KeyAlgorithm;
import software.amazon.awssdk.services.acm.model.KeyAlgorithmListCopier;
import software.amazon.awssdk.services.acm.model.KeyUsageFilterListCopier;
import software.amazon.awssdk.services.acm.model.KeyUsageName;
import software.amazon.awssdk.services.acm.transform.FiltersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filters
implements StructuredPojo,
ToCopyableBuilder<Builder, Filters> {
    private final List<String> extendedKeyUsage;
    private final List<String> keyUsage;
    private final List<String> keyTypes;

    private Filters(BuilderImpl builder) {
        this.extendedKeyUsage = builder.extendedKeyUsage;
        this.keyUsage = builder.keyUsage;
        this.keyTypes = builder.keyTypes;
    }

    public List<ExtendedKeyUsageName> extendedKeyUsage() {
        return TypeConverter.convert(this.extendedKeyUsage, ExtendedKeyUsageName::fromValue);
    }

    public List<String> extendedKeyUsageAsStrings() {
        return this.extendedKeyUsage;
    }

    public List<KeyUsageName> keyUsage() {
        return TypeConverter.convert(this.keyUsage, KeyUsageName::fromValue);
    }

    public List<String> keyUsageAsStrings() {
        return this.keyUsage;
    }

    public List<KeyAlgorithm> keyTypes() {
        return TypeConverter.convert(this.keyTypes, KeyAlgorithm::fromValue);
    }

    public List<String> keyTypesAsStrings() {
        return this.keyTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedKeyUsageAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyUsageAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)obj;
        return Objects.equals(this.extendedKeyUsageAsStrings(), other.extendedKeyUsageAsStrings()) && Objects.equals(this.keyUsageAsStrings(), other.keyUsageAsStrings()) && Objects.equals(this.keyTypesAsStrings(), other.keyTypesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Filters").add("ExtendedKeyUsage", this.extendedKeyUsageAsStrings()).add("KeyUsage", this.keyUsageAsStrings()).add("KeyTypes", this.keyTypesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extendedKeyUsage": {
                return Optional.ofNullable(clazz.cast(this.extendedKeyUsageAsStrings()));
            }
            case "keyUsage": {
                return Optional.ofNullable(clazz.cast(this.keyUsageAsStrings()));
            }
            case "keyTypes": {
                return Optional.ofNullable(clazz.cast(this.keyTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> extendedKeyUsage = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyUsage = DefaultSdkAutoConstructList.getInstance();
        private List<String> keyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filters model) {
            this.extendedKeyUsageWithStrings(model.extendedKeyUsage);
            this.keyUsageWithStrings(model.keyUsage);
            this.keyTypesWithStrings(model.keyTypes);
        }

        public final Collection<String> getExtendedKeyUsage() {
            return this.extendedKeyUsage;
        }

        @Override
        public final Builder extendedKeyUsageWithStrings(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsageWithStrings(String ... extendedKeyUsage) {
            this.extendedKeyUsageWithStrings(Arrays.asList(extendedKeyUsage));
            return this;
        }

        @Override
        public final Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copyEnumToString(extendedKeyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedKeyUsage(ExtendedKeyUsageName ... extendedKeyUsage) {
            this.extendedKeyUsage(Arrays.asList(extendedKeyUsage));
            return this;
        }

        public final void setExtendedKeyUsage(Collection<String> extendedKeyUsage) {
            this.extendedKeyUsage = ExtendedKeyUsageFilterListCopier.copy(extendedKeyUsage);
        }

        public final Collection<String> getKeyUsage() {
            return this.keyUsage;
        }

        @Override
        public final Builder keyUsageWithStrings(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsageWithStrings(String ... keyUsage) {
            this.keyUsageWithStrings(Arrays.asList(keyUsage));
            return this;
        }

        @Override
        public final Builder keyUsage(Collection<KeyUsageName> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copyEnumToString(keyUsage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyUsage(KeyUsageName ... keyUsage) {
            this.keyUsage(Arrays.asList(keyUsage));
            return this;
        }

        public final void setKeyUsage(Collection<String> keyUsage) {
            this.keyUsage = KeyUsageFilterListCopier.copy(keyUsage);
        }

        public final Collection<String> getKeyTypes() {
            return this.keyTypes;
        }

        @Override
        public final Builder keyTypesWithStrings(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypesWithStrings(String ... keyTypes) {
            this.keyTypesWithStrings(Arrays.asList(keyTypes));
            return this;
        }

        @Override
        public final Builder keyTypes(Collection<KeyAlgorithm> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copyEnumToString(keyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyTypes(KeyAlgorithm ... keyTypes) {
            this.keyTypes(Arrays.asList(keyTypes));
            return this;
        }

        public final void setKeyTypes(Collection<String> keyTypes) {
            this.keyTypes = KeyAlgorithmListCopier.copy(keyTypes);
        }

        public Filters build() {
            return new Filters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Filters> {
        public Builder extendedKeyUsageWithStrings(Collection<String> var1);

        public Builder extendedKeyUsageWithStrings(String ... var1);

        public Builder extendedKeyUsage(Collection<ExtendedKeyUsageName> var1);

        public Builder extendedKeyUsage(ExtendedKeyUsageName ... var1);

        public Builder keyUsageWithStrings(Collection<String> var1);

        public Builder keyUsageWithStrings(String ... var1);

        public Builder keyUsage(Collection<KeyUsageName> var1);

        public Builder keyUsage(KeyUsageName ... var1);

        public Builder keyTypesWithStrings(Collection<String> var1);

        public Builder keyTypesWithStrings(String ... var1);

        public Builder keyTypes(Collection<KeyAlgorithm> var1);

        public Builder keyTypes(KeyAlgorithm ... var1);
    }
}

